/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminalscompat.modcompat.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageScreenSizeEvent;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabClientLoadButtonsEvent;
import org.cyclops.integratedterminals.api.terminalstorage.event.TerminalStorageTabClientSearchFieldUpdateEvent;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.client.gui.image.Images;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageItem;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStoragePart;
import org.cyclops.integratedterminals.part.PartTypes;
import org.cyclops.integratedterminalscompat.modcompat.common.button.TerminalButtonItemStackCraftingGridSearchSync;
import org.cyclops.integratedterminalscompat.modcompat.jei.terminalstorage.TerminalStorageGuiHandler;
import org.cyclops.integratedterminalscompat.modcompat.jei.terminalstorage.TerminalStorageRecipeTransferHandler;

@JeiPlugin
public class JEIIntegratedTerminalsConfig
implements IModPlugin {
    public static ISubtypeManager subTypeManager;
    public static IJeiRuntime jeiRuntime;
    private boolean wasJeiVisible = false;

    public JEIIntegratedTerminalsConfig() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static int getItemStackMatchCondition(ItemStack itemStack) {
        String subTypeInfo = subTypeManager.getSubtypeInfo(VanillaTypes.ITEM_STACK, (Object)itemStack, UidContext.Ingredient);
        return subTypeInfo == null ? 1 : 5;
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        subTypeManager = registration.getSubtypeManager();
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(new TerminalStorageRecipeTransferHandler<ContainerTerminalStoragePart>(ContainerTerminalStoragePart.class, RegistryEntries.CONTAINER_PART_TERMINAL_STORAGE_PART), RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler(new TerminalStorageRecipeTransferHandler<ContainerTerminalStorageItem>(ContainerTerminalStorageItem.class, RegistryEntries.CONTAINER_PART_TERMINAL_STORAGE_ITEM), RecipeTypes.CRAFTING);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(ContainerScreenTerminalStorage.class, (IGuiContainerHandler)new TerminalStorageGuiHandler());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)PartTypes.TERMINAL_STORAGE.getItem()), new RecipeType[]{RecipeTypes.CRAFTING});
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("integratedterminalscompat", "main");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEIIntegratedTerminalsConfig.jeiRuntime = jeiRuntime;
    }

    @SubscribeEvent
    public void onTerminalStorageButtons(TerminalStorageTabClientLoadButtonsEvent event) {
        if (jeiRuntime != null && !event.getButtons().stream().anyMatch(button -> button instanceof TerminalButtonItemStackCraftingGridSearchSync)) {
            event.getButtons().add(new TerminalButtonItemStackCraftingGridSearchSync("jei", event.getContainer().getGuiState(), event.getClientTab(), Images.BUTTON_MIDDLE_JEI_SYNC));
        }
    }

    @SubscribeEvent
    public void onTerminalStorageScreenSize(TerminalStorageScreenSizeEvent event) {
        if (jeiRuntime != null) {
            try {
                boolean isOpen = jeiRuntime.getIngredientListOverlay().isListDisplayed() || ((BookmarkOverlay)jeiRuntime.getBookmarkOverlay()).isListDisplayed();
                boolean wasJeiVisiblePrevious = this.wasJeiVisible;
                if (isOpen) {
                    this.wasJeiVisible = true;
                    event.setWidth(event.getWidth() - 180);
                } else {
                    this.wasJeiVisible = false;
                }
                if (wasJeiVisiblePrevious != this.wasJeiVisible) {
                    ((ContainerScreenTerminalStorage)Minecraft.m_91087_().f_91080_).m_7856_();
                }
            }
            catch (ClassCastException | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void onSearchFieldUpdated(TerminalStorageTabClientSearchFieldUpdateEvent event) {
        if (jeiRuntime != null && TerminalButtonItemStackCraftingGridSearchSync.isSearchSynced(event.getClientTab())) {
            jeiRuntime.getIngredientFilter().setFilterText(event.getSearchString());
        }
    }

    @SubscribeEvent
    public void onKeyTyped(ScreenEvent.KeyReleased.Post event) {
        if (event.getScreen() instanceof ContainerScreenTerminalStorage) {
            ContainerScreenTerminalStorage gui = (ContainerScreenTerminalStorage)event.getScreen();
            if (jeiRuntime != null && jeiRuntime.getIngredientListOverlay().hasKeyboardFocus()) {
                gui.getSelectedClientTab().ifPresent(tab -> {
                    if (TerminalButtonItemStackCraftingGridSearchSync.isSearchSynced(tab)) {
                        WidgetTextFieldExtended fieldSearch = gui.getFieldSearch();
                        fieldSearch.m_94144_(jeiRuntime.getIngredientFilter().getFilterText());
                        tab.setInstanceFilter(((ContainerTerminalStorageBase)((Object)((Object)gui.getMenu()))).getSelectedChannel(), fieldSearch.m_94155_());
                    }
                });
            }
        }
    }
}

