/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollection;
import org.cyclops.cyclopscore.ingredient.collection.IngredientArrayList;
import org.cyclops.cyclopscore.ingredient.collection.IngredientCollections;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientComponentStorageObservable;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class TerminalStorageIngredientChangeEventPacket
extends PacketCodec {
    @CodecField
    private String tabId;
    @CodecField
    private CompoundTag changeData;
    @CodecField
    private int channel;
    @CodecField
    private boolean enabled;

    public TerminalStorageIngredientChangeEventPacket() {
    }

    public TerminalStorageIngredientChangeEventPacket(String tabId, IIngredientComponentStorageObservable.StorageChangeEvent<?, ?> event, boolean enabled) {
        this.tabId = tabId;
        IIngredientComponentStorageObservable.Change changeType = event.getChangeType();
        IIngredientCollection instances = event.getInstances();
        CompoundTag serialized = IngredientCollections.serialize((IIngredientCollection)instances);
        serialized.m_128405_("changeType", changeType.ordinal());
        this.changeData = serialized;
        this.channel = event.getChannel();
        this.enabled = enabled;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
        if (player.f_36096_ instanceof ContainerTerminalStorageBase) {
            ContainerTerminalStorageBase container = (ContainerTerminalStorageBase)player.f_36096_;
            IIngredientComponentStorageObservable.Change changeType = IIngredientComponentStorageObservable.Change.values()[this.changeData.m_128451_("changeType")];
            IngredientArrayList ingredients = IngredientCollections.deserialize((CompoundTag)this.changeData);
            TerminalStorageTabIngredientComponentClient tab = (TerminalStorageTabIngredientComponentClient)container.getTabClient(this.tabId);
            tab.onChange(this.channel, changeType, ingredients, this.enabled);
            if (this.tabId.equals(IngredientComponents.ITEMSTACK.getName().toString())) {
                TerminalStorageTabIngredientComponentClient tabCrafting = (TerminalStorageTabIngredientComponentClient)container.getTabClient(TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString());
                tabCrafting.onChange(this.channel, changeType, ingredients, this.enabled);
            }
            container.refreshChannelStrings();
        }
    }

    public void actionServer(Level world, ServerPlayer player) {
    }
}

