/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.block;

import cy.jdkdigital.utilitarian.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class SnadBlock
extends SandBlock {
    public SnadBlock(int pDustColor, BlockBehaviour.Properties pProperties) {
        super(pDustColor, pProperties);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter level, BlockPos pos, Direction facing, IPlantable plantable) {
        if (plantable.getPlantType(level, pos).equals(PlantType.DESERT)) {
            return true;
        }
        if (plantable.getPlantType(level, pos).equals(PlantType.BEACH)) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                boolean isWater = level.m_6425_(pos.m_121945_(direction)).m_205070_(FluidTags.f_13131_);
                boolean isFrostedIce = level.m_8055_(pos.m_121945_(direction)).m_60713_(Blocks.f_50449_);
                if (!isWater && !isFrostedIce) continue;
                return true;
            }
        }
        return super.canSustainPlant(state, level, pos, facing, plantable);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.m_213897_(pState, pLevel, pPos, pRandom);
        Block plantBlock = pLevel.m_8055_(pPos.m_7494_()).m_60734_();
        if (plantBlock instanceof IPlantable) {
            int i = 2;
            while (pLevel.m_8055_(pPos.m_6630_(i)).m_60713_(plantBlock)) {
                ++i;
            }
            BlockState state = pLevel.m_8055_(pPos.m_6630_(i - 1));
            if (state.m_61138_((Property)BlockStateProperties.f_61410_) && i < 4 + (Integer)Config.SERVER.SNAD_ADDITIONAL_HEIGHT.get() && pPos.m_6630_(i).m_123342_() < pLevel.m_151558_() && pLevel.m_8055_(pPos.m_6630_(i)).m_247087_()) {
                if ((Integer)state.m_61143_((Property)BlockStateProperties.f_61410_) == 15) {
                    if (ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (boolean)true)) {
                        pLevel.m_46597_(pPos.m_6630_(i), plantBlock.m_49966_());
                        pLevel.m_7731_(pPos.m_6630_(i - 1), (BlockState)state.m_61124_((Property)BlockStateProperties.f_61410_, (Comparable)Integer.valueOf(0)), 4);
                        ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos.m_7494_(), (BlockState)plantBlock.m_49966_());
                    }
                } else {
                    pLevel.m_7731_(pPos.m_6630_(i - 1), (BlockState)state.m_61124_((Property)BlockStateProperties.f_61410_, (Comparable)Integer.valueOf(Math.min(15, (Integer)state.m_61143_((Property)BlockStateProperties.f_61410_) + (Integer)Config.SERVER.SNAD_GROWTH_MULTIPLIER.get()))), 4);
                }
            } else {
                for (int u = 0; u < (Integer)Config.SERVER.SNAD_GROWTH_MULTIPLIER.get(); ++u) {
                    state.m_60734_().m_213898_(state, pLevel, pPos.m_6630_(i), pRandom);
                }
            }
        }
    }
}

