/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.frog.Frog;
import net.tslat.smartbrainlib.api.core.sensor.EntityFilteringSensor;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.registry.SBLSensors;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class FrogSpecificSensor<E extends LivingEntity>
extends EntityFilteringSensor<LivingEntity, E> {
    @Override
    public MemoryModuleType<LivingEntity> getMemory() {
        return MemoryModuleType.f_148194_;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.FROG_SPECIFIC.get();
    }

    @Override
    protected BiPredicate<LivingEntity, E> predicate() {
        return (target, entity) -> {
            if (BrainUtils.hasMemory(entity, MemoryModuleType.f_148201_)) {
                return false;
            }
            if (!Sensor.m_148312_((LivingEntity)entity, (LivingEntity)target)) {
                return false;
            }
            if (!Frog.m_218532_((LivingEntity)target)) {
                return false;
            }
            if (!target.m_19950_((Entity)entity, 10.0)) {
                return false;
            }
            List unreachableTargets = (List)BrainUtils.getMemory(entity, MemoryModuleType.f_238182_);
            return unreachableTargets == null || !unreachableTargets.contains(target.m_20148_());
        };
    }

    @Override
    @Nullable
    protected LivingEntity findMatches(E entity, NearestVisibleLivingEntities matcher) {
        return matcher.m_186116_(target -> this.predicate().test((LivingEntity)target, entity)).orElse(null);
    }
}

