/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.container.FluidAmountContainerMenu;
import com.refinedmods.refinedstorage.network.SetFluidFilterSlotMessage;
import com.refinedmods.refinedstorage.screen.AmountSpecifyingScreen;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class FluidAmountScreen
extends AmountSpecifyingScreen<FluidAmountContainerMenu> {
    private static final ResourceLocation TEXTURE_WIDE = new ResourceLocation("refinedstorage", "textures/gui/amount_specifying_wide.png");
    private static final ResourceLocation TEXTURE = new ResourceLocation("refinedstorage", "textures/gui/amount_specifying.png");
    private final int containerSlot;
    private final FluidStack stack;
    private final int maxAmount;
    @Nullable
    private final UnaryOperator<Screen> alternativesScreenFactory;

    public FluidAmountScreen(BaseScreen parent, Player player, int containerSlot, FluidStack stack, int maxAmount, @Nullable UnaryOperator<Screen> alternativesScreenFactory) {
        super(parent, new FluidAmountContainerMenu(player, stack), alternativesScreenFactory != null ? 194 : 172, 99, player.m_150109_(), (Component)Component.m_237115_((String)"gui.refinedstorage.fluid_amount"));
        this.containerSlot = containerSlot;
        this.stack = stack;
        this.maxAmount = maxAmount;
        this.alternativesScreenFactory = alternativesScreenFactory;
    }

    @Override
    protected int getOkCancelButtonWidth() {
        return this.alternativesScreenFactory != null ? 75 : super.getOkCancelButtonWidth();
    }

    @Override
    public void onPostInit(int x, int y) {
        super.onPostInit(x, y);
        if (this.alternativesScreenFactory != null) {
            this.addButton(x + 114, this.cancelButton.m_252907_() + 24, this.getOkCancelButtonWidth(), 20, (Component)Component.m_237115_((String)"gui.refinedstorage.alternatives"), true, true, btn -> this.f_96541_.m_91152_((Screen)this.alternativesScreenFactory.apply((Screen)this)));
        }
    }

    @Override
    protected Pair<Integer, Integer> getOkCancelPos() {
        if (this.alternativesScreenFactory == null) {
            return super.getOkCancelPos();
        }
        return Pair.of((Object)114, (Object)22);
    }

    @Override
    protected int getDefaultAmount() {
        return this.stack.getAmount();
    }

    @Override
    protected boolean canAmountGoNegative() {
        return false;
    }

    @Override
    protected int getMaxAmount() {
        return this.maxAmount;
    }

    @Override
    protected Component getOkButtonText() {
        return Component.m_237115_((String)"misc.refinedstorage.set");
    }

    @Override
    protected ResourceLocation getTexture() {
        return this.alternativesScreenFactory != null ? TEXTURE_WIDE : TEXTURE;
    }

    @Override
    protected int[] getIncrements() {
        return new int[]{100, 500, 1000, -100, -500, -1000};
    }

    @Override
    protected void onOkButtonPressed(boolean shiftDown) {
        try {
            int amount = Integer.parseInt(this.amountField.m_94155_());
            RS.NETWORK_HANDLER.sendToServer(new SetFluidFilterSlotMessage(this.containerSlot, StackUtils.copy(this.stack, amount)));
            this.close();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

