/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model.baked;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.apiimpl.network.node.DiskState;
import com.refinedmods.refinedstorage.block.DiskManipulatorBlock;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.blockentity.DiskManipulatorBlockEntity;
import com.refinedmods.refinedstorage.util.ColorMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Vector3f;

public class DiskManipulatorBakedModel
extends BakedModelWrapper<BakedModel> {
    private final BiFunction<Direction, DyeColor, BakedModel> baseConnectedModelBakery;
    private final Function<Direction, BakedModel> baseDisconnectedModelBakery;
    private final BiFunction<Direction, Vector3f, BakedModel> diskModelBakery;
    private final BiFunction<Direction, Vector3f, BakedModel> diskNearCapacityModelBakery;
    private final BiFunction<Direction, Vector3f, BakedModel> diskFullModelBakery;
    private final BiFunction<Direction, Vector3f, BakedModel> diskDisconnectedModelBakery;
    private final RenderTypeGroup renderType;
    private final LoadingCache<CacheKey, List<BakedQuad>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(CacheKey key) {
            Direction facing = (Direction)key.state.m_61143_((Property)((DiskManipulatorBlock)((Object)RSBlocks.DISK_MANIPULATOR.get(ColorMap.DEFAULT_COLOR).get())).getDirection().getProperty());
            boolean connected = (Boolean)key.state.m_61143_((Property)NetworkNodeBlock.CONNECTED);
            ArrayList<Object> quads = connected ? new ArrayList(DiskManipulatorBakedModel.this.baseConnectedModelBakery.apply(facing, key.color).m_213637_(key.state, key.side, key.random)) : new ArrayList<BakedQuad>(DiskManipulatorBakedModel.this.baseDisconnectedModelBakery.apply(facing).m_213637_(key.state, key.side, key.random));
            int x = 0;
            int y = 0;
            for (int i = 0; i < 6; ++i) {
                if (key.diskState[i] != DiskState.NONE) {
                    BakedModel diskModel = this.getDiskModelBakery(key.diskState[i]).apply(facing, this.getDiskTranslation(facing, x, y));
                    quads.addAll(diskModel.m_213637_(key.state, key.side, key.random));
                }
                ++y;
                if ((i + 1) % 3 != 0) continue;
                ++x;
                y = 0;
            }
            return quads;
        }

        private BiFunction<Direction, Vector3f, BakedModel> getDiskModelBakery(DiskState diskState) {
            return switch (diskState) {
                case DiskState.DISCONNECTED -> DiskManipulatorBakedModel.this.diskDisconnectedModelBakery;
                case DiskState.NEAR_CAPACITY -> DiskManipulatorBakedModel.this.diskNearCapacityModelBakery;
                case DiskState.FULL -> DiskManipulatorBakedModel.this.diskFullModelBakery;
                default -> DiskManipulatorBakedModel.this.diskModelBakery;
            };
        }

        private Vector3f getDiskTranslation(Direction facing, int x, int y) {
            Vector3f translation = new Vector3f();
            translation.add((0.125f + (float)x * 7.0f / 16.0f) * -1.0f, 0.0f, 0.0f);
            translation.add(0.0f, -(0.375f + 3.0f * (float)y / 16.0f), 0.0f);
            return translation;
        }
    });

    public DiskManipulatorBakedModel(BakedModel originalModel, BiFunction<Direction, DyeColor, BakedModel> baseConnectedModelBakery, Function<Direction, BakedModel> baseDisconnectedModelBakery, BiFunction<Direction, Vector3f, BakedModel> diskModelBakery, BiFunction<Direction, Vector3f, BakedModel> diskNearCapacityModelBakery, BiFunction<Direction, Vector3f, BakedModel> diskFullModelBakery, BiFunction<Direction, Vector3f, BakedModel> diskDisconnectedModelBakery, RenderTypeGroup renderTypes) {
        super(originalModel);
        this.baseConnectedModelBakery = baseConnectedModelBakery;
        this.baseDisconnectedModelBakery = baseDisconnectedModelBakery;
        this.diskModelBakery = diskModelBakery;
        this.diskNearCapacityModelBakery = diskNearCapacityModelBakery;
        this.diskFullModelBakery = diskFullModelBakery;
        this.diskDisconnectedModelBakery = diskDisconnectedModelBakery;
        this.renderType = renderTypes;
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{this.renderType.block()});
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType renderType) {
        DiskState[] diskState = (DiskState[])extraData.get(DiskManipulatorBlockEntity.DISK_STATE_PROPERTY);
        DyeColor color = RSBlocks.DISK_MANIPULATOR.getColorFromObject((DiskManipulatorBlock)state.m_60734_());
        if (diskState == null) {
            return super.getQuads(state, side, rand, extraData, renderType);
        }
        CacheKey key = new CacheKey(state, side, diskState, rand, color);
        return (List)this.cache.getUnchecked((Object)key);
    }

    private static class CacheKey {
        private final BlockState state;
        private final Direction side;
        private final DiskState[] diskState;
        private final RandomSource random;
        private final DyeColor color;

        CacheKey(BlockState state, @Nullable Direction side, DiskState[] diskState, RandomSource random, DyeColor color) {
            this.state = state;
            this.side = side;
            this.diskState = diskState;
            this.random = random;
            this.color = color;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.state.equals(cacheKey.state)) {
                return false;
            }
            if (this.side != cacheKey.side) {
                return false;
            }
            if (this.color != cacheKey.color) {
                return false;
            }
            return Arrays.equals((Object[])this.diskState, (Object[])cacheKey.diskState);
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + (this.side != null ? this.side.hashCode() : 0);
            result = 31 * result + Arrays.hashCode((Object[])this.diskState);
            return result;
        }
    }
}

