/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model;

import com.mojang.math.Transformation;
import com.refinedmods.refinedstorage.render.model.baked.PortableGridBakedModel;
import com.refinedmods.refinedstorage.util.RenderUtils;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;

public class PortableGridUnbakedGeometry
implements IUnbakedGeometry<PortableGridUnbakedGeometry> {
    private static final ResourceLocation BASE_CONNECTED_MODEL = new ResourceLocation("refinedstorage", "block/portable_grid_connected");
    private static final ResourceLocation BASE_DISCONNECTED_MODEL = new ResourceLocation("refinedstorage", "block/portable_grid_disconnected");
    private static final ResourceLocation DISK_MODEL = new ResourceLocation("refinedstorage", "block/disks/portable_grid_disk");
    private static final ResourceLocation DISK_DISCONNECTED_MODEL = new ResourceLocation("refinedstorage", "block/disks/portable_grid_disk_disconnected");
    private static final ResourceLocation DISK_FULL_MODEL = new ResourceLocation("refinedstorage", "block/disks/portable_grid_disk_full");
    private static final ResourceLocation DISK_NEAR_CAPACITY_MODEL = new ResourceLocation("refinedstorage", "block/disks/portable_grid_disk_near_capacity");

    public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
        modelGetter.apply(BASE_CONNECTED_MODEL).m_5500_(modelGetter);
        modelGetter.apply(BASE_DISCONNECTED_MODEL).m_5500_(modelGetter);
        modelGetter.apply(DISK_MODEL).m_5500_(modelGetter);
        modelGetter.apply(DISK_DISCONNECTED_MODEL).m_5500_(modelGetter);
        modelGetter.apply(DISK_FULL_MODEL).m_5500_(modelGetter);
        modelGetter.apply(DISK_NEAR_CAPACITY_MODEL).m_5500_(modelGetter);
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        ResourceLocation renderTypeHint = context.getRenderTypeHint();
        RenderTypeGroup renderTypes = renderTypeHint != null ? context.getRenderType(renderTypeHint) : RenderTypeGroup.EMPTY;
        return new PortableGridBakedModel(Objects.requireNonNull(baker.bake(BASE_CONNECTED_MODEL, modelState, spriteGetter)), this.getModelBaker(BASE_CONNECTED_MODEL, modelState, baker, spriteGetter), this.getModelBaker(BASE_DISCONNECTED_MODEL, modelState, baker, spriteGetter), this.getModelBaker(DISK_MODEL, modelState, baker, spriteGetter), this.getModelBaker(DISK_NEAR_CAPACITY_MODEL, modelState, baker, spriteGetter), this.getModelBaker(DISK_FULL_MODEL, modelState, baker, spriteGetter), this.getModelBaker(DISK_DISCONNECTED_MODEL, modelState, baker, spriteGetter), renderTypes);
    }

    private Function<Direction, BakedModel> getModelBaker(ResourceLocation id, ModelState state, ModelBaker baker, Function<Material, TextureAtlasSprite> sg) {
        return direction -> {
            Transformation rotation = new Transformation(null, RenderUtils.getQuaternion(direction), null, null);
            SimpleModelState wrappedState = new SimpleModelState(rotation, state.m_7538_());
            return baker.bake(id, (ModelState)wrappedState, sg);
        };
    }
}

