/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.inventory.player;

import com.refinedmods.refinedstorage.integration.curios.CuriosIntegration;
import com.refinedmods.refinedstorage.util.PacketBufferUtils;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;

public class PlayerSlot {
    int slot;
    String curioSlot;

    public PlayerSlot(int slot, String curioSlot) {
        this.slot = slot;
        this.curioSlot = curioSlot;
    }

    public PlayerSlot(int slot) {
        this.slot = slot;
    }

    public PlayerSlot(FriendlyByteBuf buffer) {
        this.slot = buffer.readInt();
        if (buffer.readBoolean()) {
            this.curioSlot = PacketBufferUtils.readString(buffer);
        }
    }

    public static PlayerSlot getSlotForHand(Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return new PlayerSlot(player.m_150109_().f_35977_);
        }
        return new PlayerSlot(40);
    }

    public ItemStack getStackFromSlot(Player player) {
        if (this.curioSlot == null || !CuriosIntegration.isLoaded()) {
            return player.m_150109_().m_8020_(this.slot);
        }
        LazyOptional curiosHandler = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        Optional<ItemStack> stacksHandler = curiosHandler.resolve().flatMap(handler -> handler.getStacksHandler(this.curioSlot));
        Optional<ItemStack> stack = stacksHandler.map(handler -> handler.getStacks().getStackInSlot(this.slot));
        return stack.orElse(ItemStack.f_41583_);
    }

    public void writePlayerSlot(FriendlyByteBuf buffer) {
        buffer.writeInt(this.slot);
        buffer.writeBoolean(this.curioSlot != null);
        if (this.curioSlot != null) {
            buffer.m_130070_(this.curioSlot);
        }
    }

    public int getSlotIdInPlayerInventory() {
        if (this.curioSlot != null) {
            return -1;
        }
        return this.slot;
    }
}

