/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.container.storage;

import com.klikli_dev.occultism.common.container.storage.SatchelInventory;
import com.klikli_dev.occultism.common.container.storage.SatchelSlot;
import com.klikli_dev.occultism.registry.OccultismContainers;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.util.CuriosUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SatchelContainer
extends AbstractContainerMenu {
    public static final int SATCHEL_SIZE = 117;
    protected Container satchelInventory;
    protected Inventory playerInventory;
    protected int selectedSlot;

    public SatchelContainer(int id, Inventory playerInventory, Container satchelInventory, int selectedSlot) {
        super((MenuType)OccultismContainers.SATCHEL.get(), id);
        this.satchelInventory = satchelInventory;
        this.playerInventory = playerInventory;
        this.selectedSlot = selectedSlot;
        this.setupSatchelSlots();
        this.setupPlayerInventorySlots();
        this.setupPlayerHotbar();
    }

    public static SatchelContainer createClientContainer(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        int selectedSlot = buffer.m_130242_();
        return new SatchelContainer(id, playerInventory, (Container)new SimpleContainer(117), selectedSlot);
    }

    public void m_38946_() {
        if (this.satchelInventory instanceof SatchelInventory) {
            ((SatchelInventory)this.satchelInventory).writeItemStack();
        }
        super.m_38946_();
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index >= this.satchelInventory.m_6643_() && itemstack.m_41720_() == OccultismItems.SATCHEL.get()) {
                return ItemStack.f_41583_;
            }
            if (index < this.satchelInventory.m_6643_() ? !this.m_38903_(itemstack1, this.satchelInventory.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.satchelInventory.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean m_6875_(Player player) {
        if (this.selectedSlot == -1) {
            return CuriosUtil.getBackpack(player).m_41720_() == OccultismItems.SATCHEL.get();
        }
        if (this.selectedSlot < 0 || this.selectedSlot >= player.m_150109_().m_6643_()) {
            return false;
        }
        return player.m_150109_().m_8020_(this.selectedSlot).m_41720_() == OccultismItems.SATCHEL.get();
    }

    protected void setupPlayerInventorySlots() {
        int playerInventoryTop = 174;
        int playerInventoryLeft = 44;
        int hotbarSlots = 9;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)this.playerInventory, j + i * 9 + hotbarSlots, playerInventoryLeft + j * 18, playerInventoryTop + i * 18));
            }
        }
    }

    protected void setupPlayerHotbar() {
        int hotbarTop = 232;
        int hotbarLeft = 44;
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)this.playerInventory, i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    protected void setupSatchelSlots() {
        int height = 9;
        int width = 13;
        int x = 8;
        int y = 8;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                this.m_38897_(new SatchelSlot(this.satchelInventory, j + i * width, x + j * 18, y + i * 18));
            }
        }
    }
}

