/*
 * Decompiled with CFR 0.152.
 */
package shadow.hypherionmc.mcdiscordformatter.minecraft;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import shadow.hypherionmc.mcdiscordformatter.minecraft.MinecraftSerializerOptions;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.node.Node;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.node.TextNode;
import shadow.hypherionmc.mcdiscordformatter.renderer.NodeRenderer;
import shadow.hypherionmc.mcdiscordformatter.renderer.implementation.DefaultDiscordEscapingRenderer;
import shadow.hypherionmc.mcdiscordformatter.renderer.implementation.DefaultMinecraftRenderer;

public class MinecraftSerializer {
    public static final MinecraftSerializer INSTANCE = new MinecraftSerializer(){

        @Override
        public void setDefaultOptions(MinecraftSerializerOptions<MutableComponent> defaultOptions) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }

        @Override
        public void setMarkdownDefaultOptions(MinecraftSerializerOptions<String> markdownDefaultOptions) {
            throw new UnsupportedOperationException("Cannot modify public instance");
        }
    };
    private MinecraftSerializerOptions<MutableComponent> defaultOptions;
    private MinecraftSerializerOptions<String> markdownDefaultOptions;

    public MinecraftSerializer() {
        this(MinecraftSerializerOptions.defaults(), MinecraftSerializerOptions.escapeDefaults());
    }

    public MinecraftSerializer(@NotNull MinecraftSerializerOptions<MutableComponent> defaultOptions, @NotNull MinecraftSerializerOptions<String> markdownDefaultOptions) {
        this.defaultOptions = defaultOptions;
        this.markdownDefaultOptions = markdownDefaultOptions;
    }

    public MutableComponent serialize(@NotNull String discordMessage) {
        MinecraftSerializerOptions<MutableComponent> options = this.getDefaultOptions();
        return this.serialize(discordMessage, options);
    }

    public MutableComponent serialize(@NotNull String discordMessage, @NotNull MinecraftSerializerOptions<MutableComponent> serializerOptions) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        List<Node<Object>> nodes = serializerOptions.getParser().parse(discordMessage, null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled());
        nodes = this.flattenTextNodes(nodes);
        for (Node<Object> node : nodes) {
            components.add(this.addChild(node, Component.m_237119_(), serializerOptions));
        }
        MutableComponent text = Component.m_237119_();
        components.forEach(arg_0 -> ((MutableComponent)text).m_7220_(arg_0));
        return text;
    }

    public String escapeMarkdown(@NotNull String discordMessage) {
        return this.escapeMarkdown(discordMessage, this.getMarkdownDefaultOptions());
    }

    public String escapeMarkdown(@NotNull String discordMessage, @NotNull MinecraftSerializerOptions<String> serializerOptions) {
        String output = "";
        List<Node<Object>> nodes = serializerOptions.getParser().parse(discordMessage, null, serializerOptions.getRules(), serializerOptions.isDebuggingEnabled());
        nodes = this.flattenTextNodes(nodes);
        for (Node<Object> node : nodes) {
            output = this.addChild(node, output, serializerOptions);
        }
        return output;
    }

    private MutableComponent addChild(Node<Object> node, MutableComponent styleNode, MinecraftSerializerOptions<MutableComponent> serializerOptions) {
        MutableComponent newOutput;
        List<Node<Object>> children;
        MutableComponent component = Component.m_237119_().m_6270_(styleNode.m_7383_());
        Function<Node, MutableComponent> renderWithChildren = otherNode -> this.addChild((Node<Object>)otherNode, component, serializerOptions);
        MutableComponent output = null;
        Object render = null;
        for (NodeRenderer<MutableComponent> renderer : serializerOptions.getRenderers()) {
            output = renderer.render(component, node, serializerOptions, renderWithChildren);
            if (output == null) continue;
            render = renderer;
            break;
        }
        if (output == null) {
            render = DefaultMinecraftRenderer.INSTANCE;
            output = render.render(component, node, serializerOptions, renderWithChildren);
        }
        if ((children = node.getChildren()) != null) {
            for (Node node2 : children) {
                output = output.m_7220_((Component)this.addChild((Node<Object>)node2, output, serializerOptions));
            }
        }
        if ((newOutput = render.renderAfterChildren(output, node, serializerOptions, renderWithChildren)) != null) {
            output = newOutput;
        }
        return output;
    }

    private String addChild(Node<Object> node, String input, MinecraftSerializerOptions<String> serializerOptions) {
        String newOutput;
        List<Node<Object>> children;
        Function<Node, String> renderWithChildren = otherNode -> this.addChild((Node<Object>)otherNode, input, serializerOptions);
        String output = null;
        Object render = null;
        for (NodeRenderer<String> renderer : serializerOptions.getRenderers()) {
            output = renderer.render(output, node, serializerOptions, renderWithChildren);
            if (output == null) continue;
            render = renderer;
            break;
        }
        if (output == null) {
            render = DefaultDiscordEscapingRenderer.INSTANCE;
            output = render.render(input, node, serializerOptions, renderWithChildren);
        }
        if ((children = node.getChildren()) != null) {
            for (Node node2 : children) {
                output = this.addChild((Node<Object>)node2, output, serializerOptions);
            }
        }
        if ((newOutput = render.renderAfterChildren(output, node, serializerOptions, renderWithChildren)) != null) {
            output = newOutput;
        }
        return output;
    }

    private <R, T extends Node<R>> List<T> flattenTextNodes(List<T> nodes) {
        ArrayList<Node> newNodes = new ArrayList<Node>();
        TextNode previousNode = null;
        for (Node node : nodes) {
            List children = node.getChildren();
            if (!children.isEmpty()) {
                if (previousNode != null) {
                    newNodes.add(previousNode);
                    previousNode = null;
                }
                List childNodes = this.flattenTextNodes(children);
                node.getChildren().clear();
                node.getChildren().addAll(childNodes);
                newNodes.add(node);
                continue;
            }
            if (!(node instanceof TextNode)) {
                if (previousNode != null) {
                    newNodes.add(previousNode);
                    previousNode = null;
                }
                newNodes.add(node);
                continue;
            }
            if (previousNode == null) {
                previousNode = (TextNode)node;
                continue;
            }
            previousNode = new TextNode(previousNode.getContent() + ((TextNode)node).getContent());
        }
        if (previousNode != null) {
            newNodes.add(previousNode);
        }
        return newNodes;
    }

    public MinecraftSerializerOptions<MutableComponent> getDefaultOptions() {
        return this.defaultOptions;
    }

    public MinecraftSerializerOptions<String> getMarkdownDefaultOptions() {
        return this.markdownDefaultOptions;
    }

    public void setDefaultOptions(MinecraftSerializerOptions<MutableComponent> defaultOptions) {
        this.defaultOptions = defaultOptions;
    }

    public void setMarkdownDefaultOptions(MinecraftSerializerOptions<String> markdownDefaultOptions) {
        this.markdownDefaultOptions = markdownDefaultOptions;
    }
}

