/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.tile;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.silentchaos512.lib.util.NBTSerializer;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
public @interface SyncVariable {
    public String name();

    public boolean onRead() default true;

    public boolean onWrite() default true;

    public boolean onPacket() default true;

    public static final class Helper {
        static final Map<Class, NBTSerializer> SERIALIZERS = new HashMap<Class, NBTSerializer>();

        private Helper() {
        }

        public static <T> void registerSerializer(Class<T> clazz, final Function<CompoundTag, T> reader, final BiConsumer<CompoundTag, T> writer) {
            SERIALIZERS.put(clazz, new NBTSerializer<T>(){

                @Override
                public T read(CompoundTag tags) {
                    return reader.apply(tags);
                }

                @Override
                public void write(CompoundTag tags, T obj) {
                    writer.accept(tags, obj);
                }
            });
        }

        public static void readSyncVars(Object obj, CompoundTag tags) {
            for (Field field : obj.getClass().getDeclaredFields()) {
                for (Annotation annotation : field.getDeclaredAnnotations()) {
                    if (!(annotation instanceof SyncVariable)) continue;
                    SyncVariable sync = (SyncVariable)annotation;
                    try {
                        if (!field.canAccess(obj)) {
                            field.setAccessible(true);
                        }
                        String name = sync.name();
                        if (field.getType() == Integer.TYPE) {
                            field.setInt(obj, tags.m_128451_(name));
                            continue;
                        }
                        if (field.getType() == Float.TYPE) {
                            field.setFloat(obj, tags.m_128457_(name));
                            continue;
                        }
                        if (field.getType() == String.class) {
                            field.set(obj, tags.m_128461_(name));
                            continue;
                        }
                        if (field.getType() == Boolean.TYPE) {
                            field.setBoolean(obj, tags.m_128471_(name));
                            continue;
                        }
                        if (field.getType() == Double.TYPE) {
                            field.setDouble(obj, tags.m_128459_(name));
                            continue;
                        }
                        if (field.getType() == Long.TYPE) {
                            field.setLong(obj, tags.m_128454_(name));
                            continue;
                        }
                        if (field.getType() == Short.TYPE) {
                            field.setShort(obj, tags.m_128448_(name));
                            continue;
                        }
                        if (field.getType() == Byte.TYPE) {
                            field.setByte(obj, tags.m_128445_(name));
                            continue;
                        }
                        if (SERIALIZERS.containsKey(field.getType())) {
                            NBTSerializer serializer = SERIALIZERS.get(field.getType());
                            CompoundTag compound = tags.m_128469_(name);
                            field.set(obj, serializer.read(compound));
                            continue;
                        }
                        throw new IllegalArgumentException("Don't know how to read type " + field.getType() + " from NBT!");
                    }
                    catch (IllegalAccessException | IllegalArgumentException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        public static CompoundTag writeSyncVars(Object obj, CompoundTag tags, Type syncType) {
            for (Field field : obj.getClass().getDeclaredFields()) {
                for (Annotation annotation : field.getDeclaredAnnotations()) {
                    if (!(annotation instanceof SyncVariable)) continue;
                    SyncVariable sync = (SyncVariable)annotation;
                    if ((syncType != Type.WRITE || !sync.onWrite()) && (syncType != Type.PACKET || !sync.onPacket())) continue;
                    try {
                        if (!field.canAccess(obj)) {
                            field.setAccessible(true);
                        }
                        String name = sync.name();
                        if (field.getType() == Integer.TYPE) {
                            tags.m_128405_(name, field.getInt(obj));
                            continue;
                        }
                        if (field.getType() == Float.TYPE) {
                            tags.m_128350_(name, field.getFloat(obj));
                            continue;
                        }
                        if (field.getType() == String.class) {
                            tags.m_128359_(name, (String)field.get(obj));
                            continue;
                        }
                        if (field.getType() == Boolean.TYPE) {
                            tags.m_128379_(name, field.getBoolean(obj));
                            continue;
                        }
                        if (field.getType() == Double.TYPE) {
                            tags.m_128347_(name, field.getDouble(obj));
                            continue;
                        }
                        if (field.getType() == Long.TYPE) {
                            tags.m_128356_(name, field.getLong(obj));
                            continue;
                        }
                        if (field.getType() == Short.TYPE) {
                            tags.m_128376_(name, field.getShort(obj));
                            continue;
                        }
                        if (field.getType() == Byte.TYPE) {
                            tags.m_128344_(name, field.getByte(obj));
                            continue;
                        }
                        if (SERIALIZERS.containsKey(field.getType())) {
                            CompoundTag compound = new CompoundTag();
                            NBTSerializer serializer = SERIALIZERS.get(field.getType());
                            serializer.write(compound, field.get(obj));
                            tags.m_128365_(name, (Tag)compound);
                            continue;
                        }
                        throw new IllegalArgumentException("Don't know how to write type " + field.getType() + " to NBT!");
                    }
                    catch (IllegalAccessException | IllegalArgumentException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            return tags;
        }
    }

    public static enum Type {
        READ,
        WRITE,
        PACKET;

    }
}

