/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.image.impl;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.isxander.yacl3.debug.DebugProperties;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import dev.isxander.yacl3.gui.image.ImageRendererFactory;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class DynamicTextureImage
implements ImageRenderer {
    protected static final TextureManager textureManager = Minecraft.m_91087_().m_91097_();
    protected NativeImage image;
    protected DynamicTexture texture;
    protected final ResourceLocation uniqueLocation;
    protected final int width;
    protected final int height;

    public DynamicTextureImage(NativeImage image, ResourceLocation location) {
        RenderSystem.assertOnRenderThread();
        this.image = image;
        this.texture = new DynamicTexture(image);
        this.uniqueLocation = location;
        textureManager.m_118495_(this.uniqueLocation, (AbstractTexture)this.texture);
        this.width = image.m_84982_();
        this.height = image.m_85084_();
    }

    @Override
    public int render(GuiGraphics graphics, int x, int y, int renderWidth, float tickDelta) {
        if (this.image == null) {
            return 0;
        }
        float ratio = (float)renderWidth / (float)this.width;
        int targetHeight = (int)((float)this.height * ratio);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        graphics.m_280168_().m_85841_(ratio, ratio, 1.0f);
        if (DebugProperties.IMAGE_FILTERING) {
            GlStateManager._texParameter((int)3553, (int)10240, (int)9729);
            GlStateManager._texParameter((int)3553, (int)10241, (int)9729);
        }
        GuiUtils.blitGuiTex(graphics, this.uniqueLocation, 0, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        graphics.m_280168_().m_85849_();
        return targetHeight;
    }

    @Override
    public void close() {
        this.image.close();
        this.image = null;
        this.texture = null;
        textureManager.m_118513_(this.uniqueLocation);
    }

    public static ImageRendererFactory fromPath(Path imagePath, ResourceLocation location) {
        return () -> () -> new DynamicTextureImage(NativeImage.m_85058_((InputStream)new FileInputStream(imagePath.toFile())), location);
    }
}

