/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui;

import com.google.common.collect.ImmutableList;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.ListOptionEntry;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.DescriptionWithName;
import dev.isxander.yacl3.gui.ElementListWidgetExt;
import dev.isxander.yacl3.gui.LowProfileButtonWidget;
import dev.isxander.yacl3.gui.TextScaledButtonWidget;
import dev.isxander.yacl3.gui.TooltipButtonWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public class OptionListWidget
extends ElementListWidgetExt<Entry> {
    private final YACLScreen yaclScreen;
    private final ConfigCategory category;
    private ImmutableList<Entry> viewableChildren;
    private String searchQuery = "";
    private final Consumer<DescriptionWithName> hoverEvent;
    private DescriptionWithName lastHoveredOption;

    public OptionListWidget(YACLScreen screen, ConfigCategory category, Minecraft client, int x, int y, int width, int height, Consumer<DescriptionWithName> hoverEvent) {
        super(client, x, y, width, height, true);
        this.yaclScreen = screen;
        this.category = category;
        this.hoverEvent = hoverEvent;
        this.refreshOptions();
        for (OptionGroup group : category.groups()) {
            if (!(group instanceof ListOption)) continue;
            ListOption listOption = (ListOption)group;
            listOption.addRefreshListener(() -> this.refreshListEntries(listOption, category));
        }
    }

    public void refreshOptions() {
        this.m_93516_();
        for (OptionGroup group : this.category.groups()) {
            GroupSeparatorEntry groupSeparatorEntry;
            if (!group.isRoot()) {
                GroupSeparatorEntry groupSeparatorEntry2;
                if (group instanceof ListOption) {
                    ListOption listOption = (ListOption)group;
                    groupSeparatorEntry2 = new ListGroupSeparatorEntry(listOption, this.yaclScreen);
                } else {
                    groupSeparatorEntry2 = new GroupSeparatorEntry(group, this.yaclScreen);
                }
                groupSeparatorEntry = groupSeparatorEntry2;
                this.m_7085_((AbstractSelectionList.Entry)groupSeparatorEntry);
            } else {
                groupSeparatorEntry = null;
            }
            ArrayList<Entry> optionEntries = new ArrayList<Entry>();
            if (groupSeparatorEntry instanceof ListGroupSeparatorEntry) {
                ListGroupSeparatorEntry listGroupSeparatorEntry = (ListGroupSeparatorEntry)groupSeparatorEntry;
                if (listGroupSeparatorEntry.listOption.options().isEmpty()) {
                    EmptyListLabel emptyListLabel = new EmptyListLabel(listGroupSeparatorEntry, this.category);
                    this.m_7085_((AbstractSelectionList.Entry)emptyListLabel);
                    optionEntries.add(emptyListLabel);
                }
            }
            for (Option option : group.options()) {
                OptionEntry entry = new OptionEntry(option, this.category, group, groupSeparatorEntry, option.controller().provideWidget(this.yaclScreen, this.getDefaultEntryDimension()));
                this.m_7085_((AbstractSelectionList.Entry)entry);
                optionEntries.add(entry);
            }
            if (groupSeparatorEntry == null) continue;
            groupSeparatorEntry.setChildEntries(optionEntries);
        }
        this.recacheViewableChildren();
        this.m_93410_(0.0);
        this.resetSmoothScrolling();
    }

    private void refreshListEntries(ListOption<?> listOption, ConfigCategory category) {
        ListGroupSeparatorEntry groupSeparator = super.m_6702_().stream().filter(e -> {
            if (!(e instanceof ListGroupSeparatorEntry)) return false;
            ListGroupSeparatorEntry gs = (ListGroupSeparatorEntry)((Object)e);
            if (gs.group != listOption) return false;
            return true;
        }).map(ListGroupSeparatorEntry.class::cast).findAny().orElse(null);
        if (groupSeparator == null) {
            YACLConstants.LOGGER.warn("Can't find group seperator to refresh list option entries for list option " + String.valueOf(listOption.name()));
            return;
        }
        for (Entry entry : groupSeparator.childEntries) {
            super.m_93502_((AbstractSelectionList.Entry)entry);
        }
        groupSeparator.childEntries.clear();
        if (listOption.options().isEmpty()) {
            EmptyListLabel emptyListLabel = new EmptyListLabel(groupSeparator, category);
            this.addEntryBelow(groupSeparator, emptyListLabel);
            groupSeparator.childEntries.add(emptyListLabel);
            return;
        }
        Entry lastEntry = groupSeparator;
        for (ListOptionEntry listOptionEntry : listOption.options()) {
            OptionEntry optionEntry = new OptionEntry(listOptionEntry, category, listOption, groupSeparator, listOptionEntry.controller().provideWidget(this.yaclScreen, this.getDefaultEntryDimension()));
            this.addEntryBelow(lastEntry, optionEntry);
            groupSeparator.childEntries.add(optionEntry);
            lastEntry = optionEntry;
        }
    }

    public Dimension<Integer> getDefaultEntryDimension() {
        return Dimension.ofInt(this.m_5747_(), 0, this.m_5759_(), 20);
    }

    public void expandAllGroups() {
        for (Entry entry : super.m_6702_()) {
            if (!(entry instanceof GroupSeparatorEntry)) continue;
            GroupSeparatorEntry groupSeparatorEntry = (GroupSeparatorEntry)entry;
            groupSeparatorEntry.setExpanded(true);
        }
    }

    public int m_5747_() {
        return super.m_5747_() - 6;
    }

    public int m_5759_() {
        return this.m_5711_() - 6 - 20;
    }

    public void updateSearchQuery(String query) {
        this.searchQuery = query;
        this.expandAllGroups();
        this.recacheViewableChildren();
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (Entry child : this.m_6702_()) {
            if (child == this.getEntryAtPosition(mouseX, mouseY) || !(child instanceof OptionEntry)) continue;
            OptionEntry optionEntry = (OptionEntry)child;
            optionEntry.widget.unfocus();
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double vertical) {
        super.m_6050_(mouseX, mouseY, vertical);
        for (Entry child : this.m_6702_()) {
            if (child.m_6050_(mouseX, mouseY, vertical)) break;
        }
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.m_7222_() != null && this.m_7282_() && this.isValidMouseClick(button)) {
            return ((Entry)this.m_7222_()).m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        for (Entry child : this.m_6702_()) {
            if (!child.m_7933_(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        for (Entry child : this.m_6702_()) {
            if (!child.m_5534_(chr, modifiers)) continue;
            return true;
        }
        return super.m_5534_(chr, modifiers);
    }

    public void recacheViewableChildren() {
        this.viewableChildren = ImmutableList.copyOf(super.m_6702_().stream().filter(Entry::isViewable).toList());
        int i = 0;
        for (Entry entry : this.viewableChildren) {
            if (entry instanceof OptionEntry) {
                OptionEntry optionEntry = (OptionEntry)entry;
                optionEntry.widget.setDimension(optionEntry.widget.getDimension().withY(this.m_7610_(i)));
            }
            ++i;
        }
    }

    public List<Entry> m_6702_() {
        return this.viewableChildren;
    }

    public void addEntry(int index, Entry entry) {
        super.m_6702_().add(index, entry);
        this.recacheViewableChildren();
    }

    public void addEntryBelow(Entry below, Entry entry) {
        int idx = super.m_6702_().indexOf((Object)below) + 1;
        if (idx == 0) {
            throw new IllegalStateException("The entry to insert below does not exist!");
        }
        this.addEntry(idx, entry);
    }

    public void addEntryBelowWithoutScroll(Entry below, Entry entry) {
        double d = (double)this.contentHeight() - this.scrollAmount();
        this.addEntryBelow(below, entry);
        this.m_93410_((double)this.contentHeight() - d);
    }

    public boolean removeEntryFromTop(Entry entry) {
        boolean ret = super.m_239045_((AbstractSelectionList.Entry)entry);
        this.recacheViewableChildren();
        return ret;
    }

    public boolean removeEntry(Entry entry) {
        boolean ret = super.m_93502_((AbstractSelectionList.Entry)entry);
        this.recacheViewableChildren();
        return ret;
    }

    private void setHoverDescription(DescriptionWithName description) {
        if (description != this.lastHoveredOption) {
            this.lastHoveredOption = description;
            this.hoverEvent.accept(description);
        }
    }

    public class ListGroupSeparatorEntry
    extends GroupSeparatorEntry {
        private final ListOption<?> listOption;
        private final TextScaledButtonWidget resetListButton;
        private final TooltipButtonWidget addListButton;

        private ListGroupSeparatorEntry(ListOption<?> group, Screen screen) {
            super(group, screen);
            this.listOption = group;
            this.resetListButton = new TextScaledButtonWidget(screen, OptionListWidget.this.m_93520_() - 20, -50, 20, 20, 2.0f, (Component)Component.m_237113_((String)"\u21bb"), button -> group.requestSetDefault());
            group.addListener((opt, val) -> {
                this.resetListButton.f_93623_ = !opt.isPendingValueDefault() && opt.available();
            });
            this.resetListButton.f_93623_ = !group.isPendingValueDefault() && group.available();
            this.addListButton = new TooltipButtonWidget(OptionListWidget.this.yaclScreen, this.resetListButton.m_252754_() - 20, -50, 20, 20, (Component)Component.m_237113_((String)"+"), (Component)Component.m_237115_((String)"yacl.list.add_top"), btn -> {
                group.insertNewEntry();
                this.setExpanded(true);
            });
            this.updateExpandMinimizeText();
            this.minimizeIfUnavailable();
        }

        @Override
        public void m_6311_(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.updateExpandMinimizeText();
            super.m_6311_(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            int buttonY = this.expandMinimizeButton.m_252907_();
            this.resetListButton.m_253211_(buttonY);
            this.addListButton.m_253211_(buttonY);
            this.resetListButton.m_88315_(graphics, mouseX, mouseY, tickDelta);
            this.addListButton.m_88315_(graphics, mouseX, mouseY, tickDelta);
        }

        private void minimizeIfUnavailable() {
            if (!this.listOption.available() && this.isExpanded()) {
                this.setExpanded(false);
            }
        }

        @Override
        protected void updateExpandMinimizeText() {
            super.updateExpandMinimizeText();
            boolean bl = this.expandMinimizeButton.f_93623_ = this.listOption == null || this.listOption.available();
            if (this.addListButton != null) {
                this.addListButton.f_93623_ = this.expandMinimizeButton.f_93623_ && this.listOption.numberOfEntries() < this.listOption.maximumNumberOfEntries();
            }
        }

        @Override
        public void setExpanded(boolean expanded) {
            super.setExpanded(this.listOption.available() && expanded);
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)((Object)this.expandMinimizeButton), (Object)((Object)this.addListButton), (Object)((Object)this.resetListButton));
        }
    }

    public class GroupSeparatorEntry
    extends Entry {
        protected final OptionGroup group;
        protected final MultiLineLabel wrappedName;
        protected final MultiLineLabel wrappedTooltip;
        protected final LowProfileButtonWidget expandMinimizeButton;
        protected final Screen screen;
        protected final Font font;
        protected boolean groupExpanded;
        protected List<Entry> childEntries;
        private int y;

        private GroupSeparatorEntry(OptionGroup group, Screen screen) {
            this.font = Minecraft.m_91087_().f_91062_;
            this.childEntries = new ArrayList<Entry>();
            this.group = group;
            this.screen = screen;
            this.wrappedName = MultiLineLabel.m_94341_((Font)this.font, (FormattedText)group.name(), (int)(OptionListWidget.this.m_5759_() - 45));
            this.wrappedTooltip = MultiLineLabel.m_94341_((Font)this.font, (FormattedText)group.tooltip(), (int)(screen.f_96543_ / 3 * 2 - 10));
            this.groupExpanded = !group.collapsed();
            this.expandMinimizeButton = new LowProfileButtonWidget(0, 0, 20, 20, (Component)Component.m_237119_(), btn -> this.onExpandButtonPress());
            this.updateExpandMinimizeText();
        }

        public void m_6311_(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.y = y;
            int buttonY = y + entryHeight / 2 - this.expandMinimizeButton.m_93694_() / 2 + 1;
            this.expandMinimizeButton.m_253211_(buttonY);
            this.expandMinimizeButton.m_252865_(x);
            this.expandMinimizeButton.m_88315_(graphics, mouseX, mouseY, tickDelta);
            this.wrappedName.m_6276_(graphics, x + entryWidth / 2, y + this.getYPadding());
            if (this.isHovered()) {
                OptionListWidget.this.setHoverDescription(DescriptionWithName.of(this.group.name(), this.group.description()));
            }
        }

        public boolean isExpanded() {
            return this.groupExpanded;
        }

        public void setExpanded(boolean expanded) {
            if (this.groupExpanded == expanded) {
                return;
            }
            this.groupExpanded = expanded;
            this.updateExpandMinimizeText();
            OptionListWidget.this.recacheViewableChildren();
        }

        protected void onExpandButtonPress() {
            this.setExpanded(!this.isExpanded());
        }

        protected void updateExpandMinimizeText() {
            this.expandMinimizeButton.m_93666_((Component)Component.m_237113_((String)(this.isExpanded() ? "\u25bc" : "\u25b6")));
        }

        public void setChildEntries(List<? extends Entry> childEntries) {
            this.childEntries.clear();
            this.childEntries.addAll(childEntries);
        }

        @Override
        public boolean isViewable() {
            return OptionListWidget.this.searchQuery.isEmpty() || this.childEntries.stream().anyMatch(Entry::isViewable);
        }

        @Override
        public int getItemHeight() {
            int n = Math.max(this.wrappedName.m_5770_(), 1);
            Objects.requireNonNull(this.font);
            return n * 9 + this.getYPadding() * 2;
        }

        private int getYPadding() {
            return 6;
        }

        public void m_93692_(boolean focused) {
            super.m_93692_(focused);
            if (focused) {
                OptionListWidget.this.setHoverDescription(DescriptionWithName.of(this.group.name(), this.group.description()));
            }
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput builder) {
                    builder.m_169146_(NarratedElementType.TITLE, GroupSeparatorEntry.this.group.name());
                    builder.m_169146_(NarratedElementType.HINT, GroupSeparatorEntry.this.group.tooltip());
                }
            });
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)((Object)this.expandMinimizeButton));
        }
    }

    public class EmptyListLabel
    extends Entry {
        private final ListGroupSeparatorEntry parent;
        private final String groupName;
        private final String categoryName;

        public EmptyListLabel(ListGroupSeparatorEntry parent, ConfigCategory category) {
            this.parent = parent;
            this.groupName = parent.group.name().getString().toLowerCase();
            this.categoryName = category.name().getString().toLowerCase();
        }

        public void m_6311_(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            graphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"yacl.list.empty").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}), x + entryWidth / 2, y, -1);
        }

        @Override
        public boolean isViewable() {
            return this.parent.isExpanded() && (OptionListWidget.this.searchQuery.isEmpty() || this.groupName.contains(OptionListWidget.this.searchQuery));
        }

        @Override
        public int getItemHeight() {
            return 11;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of();
        }
    }

    public class OptionEntry
    extends Entry {
        public final Option<?> option;
        public final ConfigCategory category;
        public final OptionGroup group;
        @Nullable
        public final GroupSeparatorEntry groupSeparatorEntry;
        public final AbstractWidget widget;
        private final TextScaledButtonWidget resetButton;
        private final String categoryName;
        private final String groupName;

        public OptionEntry(Option<?> option, ConfigCategory category, @Nullable OptionGroup group, GroupSeparatorEntry groupSeparatorEntry, AbstractWidget widget) {
            this.option = option;
            this.category = category;
            this.group = group;
            this.groupSeparatorEntry = groupSeparatorEntry;
            this.widget = widget;
            this.categoryName = category.name().getString().toLowerCase();
            this.groupName = group.name().getString().toLowerCase();
            if (option.canResetToDefault() && this.widget.canReset()) {
                this.widget.setDimension(this.widget.getDimension().expanded(-20, 0));
                this.resetButton = new TextScaledButtonWidget((Screen)OptionListWidget.this.yaclScreen, (int)widget.getDimension().xLimit(), -50, 20, 20, 2.0f, (Component)Component.m_237113_((String)"\u21bb"), button -> option.requestSetDefault());
                option.addListener((opt, val) -> {
                    this.resetButton.f_93623_ = !opt.isPendingValueDefault() && opt.available();
                });
                this.resetButton.f_93623_ = !option.isPendingValueDefault() && option.available();
            } else {
                this.resetButton = null;
            }
        }

        public void m_6311_(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.widget.setDimension(this.widget.getDimension().withY(y));
            this.widget.m_88315_(graphics, mouseX, mouseY, tickDelta);
            if (this.resetButton != null) {
                this.resetButton.m_253211_(y);
                this.resetButton.m_88315_(graphics, mouseX, mouseY, tickDelta);
            }
            if (this.isHovered()) {
                OptionListWidget.this.setHoverDescription(DescriptionWithName.of(this.option.name(), this.option.description()));
            }
        }

        public boolean m_6050_(double mouseX, double mouseY, double vertical) {
            return this.widget.m_6050_(mouseX, mouseY, vertical);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            return this.widget.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_5534_(char chr, int modifiers) {
            return this.widget.m_5534_(chr, modifiers);
        }

        @Override
        public boolean isViewable() {
            return !(this.groupSeparatorEntry != null && !this.groupSeparatorEntry.isExpanded() || !OptionListWidget.this.searchQuery.isEmpty() && !this.groupName.contains(OptionListWidget.this.searchQuery) && !this.widget.matchesSearch(OptionListWidget.this.searchQuery));
        }

        @Override
        public int getItemHeight() {
            return Math.max(this.widget.getDimension().height(), this.resetButton != null ? this.resetButton.m_93694_() : 0) + 2;
        }

        public void m_93692_(boolean focused) {
            super.m_93692_(focused);
            if (focused) {
                OptionListWidget.this.setHoverDescription(DescriptionWithName.of(this.option.name(), this.option.description()));
            }
        }

        public List<? extends NarratableEntry> m_142437_() {
            if (this.resetButton == null) {
                return ImmutableList.of((Object)this.widget);
            }
            return ImmutableList.of((Object)this.widget, (Object)((Object)this.resetButton));
        }

        public List<? extends GuiEventListener> m_6702_() {
            if (this.resetButton == null) {
                return ImmutableList.of((Object)this.widget);
            }
            return ImmutableList.of((Object)this.widget, (Object)((Object)this.resetButton));
        }
    }

    public abstract class Entry
    extends ElementListWidgetExt.Entry<Entry> {
        public boolean isViewable() {
            return true;
        }

        protected boolean isHovered() {
            return Objects.equals(OptionListWidget.this.m_168795_(), (Object)this);
        }
    }
}

