/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.LevelTools;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ModuleTools {
    public static boolean hasModuleTarget(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        return stack.m_41783_().m_128441_("monitorx");
    }

    public static void setPositionInModule(ItemStack stack, ResourceKey<Level> dimension, BlockPos pos, String name) {
        CompoundTag tag = stack.m_41784_();
        if (dimension != null) {
            tag.m_128359_("monitordim", dimension.m_135782_().toString());
        }
        if (name != null) {
            tag.m_128359_("monitorname", name);
        }
        tag.m_128405_("monitorx", pos.m_123341_());
        tag.m_128405_("monitory", pos.m_123342_());
        tag.m_128405_("monitorz", pos.m_123343_());
    }

    public static void clearPositionInModule(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_("monitordim");
        tag.m_128473_("monitorx");
        tag.m_128473_("monitory");
        tag.m_128473_("monitorz");
        tag.m_128473_("monitorname");
    }

    public static BlockPos getPositionFromModule(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        int monitorx = tag.m_128451_("monitorx");
        int monitory = tag.m_128451_("monitory");
        int monitorz = tag.m_128451_("monitorz");
        return new BlockPos(monitorx, monitory, monitorz);
    }

    public static ResourceKey<Level> getDimensionFromModule(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("monitordim")) {
            return LevelTools.getId(tag.m_128461_("monitordim"));
        }
        return null;
    }

    public static String getTargetString(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("monitorx")) {
            int monitorx = tag.m_128451_("monitorx");
            int monitory = tag.m_128451_("monitory");
            int monitorz = tag.m_128451_("monitorz");
            String monitorname = tag.m_128461_("monitorname");
            String monitordim = tag.m_128461_("monitordim");
            if (!monitordim.isEmpty()) {
                return monitorname + " (at " + monitorx + "," + monitory + "," + monitorz + ", " + monitordim + ")";
            }
            return monitorname + " (at " + monitorx + "," + monitory + "," + monitorz + ")";
        }
        return "<unset>";
    }

    public static boolean installModule(Player player, ItemStack heldItem, InteractionHand hand, BlockPos pos, int start, int stop) {
        Level world = player.m_20193_();
        BlockEntity te = world.m_7702_(pos);
        if (te == null) {
            return false;
        }
        return te.getCapability(ForgeCapabilities.ITEM_HANDLER).map(inventory -> {
            for (int i = start; i <= stop; ++i) {
                if (!inventory.getStackInSlot(i).m_41619_()) continue;
                ItemStack copy = heldItem.m_41777_();
                copy.m_41764_(1);
                if (!(inventory instanceof IItemHandlerModifiable)) {
                    throw new IllegalStateException("Not an IItemHandlerModifiable!");
                }
                ((IItemHandlerModifiable)inventory).setStackInSlot(i, copy);
                heldItem.m_41774_(1);
                if (heldItem.m_41619_()) {
                    player.m_21008_(hand, ItemStack.f_41583_);
                }
                if (world.f_46443_) {
                    player.m_5661_((Component)ComponentFactory.literal("Installed module"), false);
                }
                return true;
            }
            return false;
        }).orElse(false);
    }
}

