/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.fastbench.util;

import dev.shadowsoffire.fastbench.FastBench;
import dev.shadowsoffire.fastbench.util.CraftingInventoryExt;
import dev.shadowsoffire.fastbench.util.FastBenchUtil;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fastbench")
public class SlotUpdateManager {
    private static final Map<CraftingInventoryExt, Runnable> UPDATES = new IdentityHashMap<CraftingInventoryExt, Runnable>();
    private static long serverTicks = 0L;

    public static void queueSlotUpdate(Level level, Player player, CraftingInventoryExt inv, ResultContainer result) {
        if (level.f_46443_) {
            return;
        }
        Runnable task = () -> FastBenchUtil.slotChangedCraftingGrid(level, player, inv, result);
        UPDATES.putIfAbsent(inv, task);
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.END && ++serverTicks % (long)FastBench.gridUpdateInterval == 0L) {
            UPDATES.values().forEach(Runnable::run);
            UPDATES.clear();
        }
    }
}

