/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import java.util.List;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.FluidSlurryToSlurryRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@RecipeTypeMapper
public class FluidSlurryToSlurryRecipeMapper
implements IRecipeTypeMapper {
    public String getName() {
        return "MekFluidSlurryToSlurry";
    }

    public String getDescription() {
        return "Maps Mekanism washing recipes.";
    }

    public boolean canHandle(RecipeType<?> recipeType) {
        return recipeType == MekanismRecipeType.WASHING.get();
    }

    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, Recipe<?> iRecipe, RegistryAccess registryAccess, INSSFakeGroupManager groupManager) {
        if (!(iRecipe instanceof FluidSlurryToSlurryRecipe)) {
            return false;
        }
        FluidSlurryToSlurryRecipe recipe = (FluidSlurryToSlurryRecipe)iRecipe;
        boolean handled = false;
        List<@NotNull TYPE> fluidRepresentations = recipe.getFluidInput().getRepresentations();
        List<@NotNull TYPE> slurryRepresentations = ((ChemicalStackIngredient.SlurryStackIngredient)recipe.getChemicalInput()).getRepresentations();
        for (FluidStack fluidRepresentation : fluidRepresentations) {
            NSSFluid nssFluid = NSSFluid.createFluid((FluidStack)fluidRepresentation);
            for (SlurryStack slurryRepresentation : slurryRepresentations) {
                SlurryStack output = recipe.getOutput(fluidRepresentation, slurryRepresentation);
                if (output.isEmpty()) continue;
                IngredientHelper ingredientHelper = new IngredientHelper(mapper);
                ingredientHelper.put((NormalizedSimpleStack)nssFluid, fluidRepresentation.getAmount());
                ingredientHelper.put(slurryRepresentation);
                if (!ingredientHelper.addAsConversion(output)) continue;
                handled = true;
            }
        }
        return handled;
    }
}

