/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import java.util.function.DoubleSupplier;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedValue;
import net.minecraftforge.common.ForgeConfigSpec;

public class CachedDoubleValue
extends CachedValue<Double>
implements DoubleSupplier {
    private boolean resolved;
    private double cachedValue;

    private CachedDoubleValue(IMekanismConfig config, ForgeConfigSpec.ConfigValue<Double> internal) {
        super(config, internal);
    }

    public static CachedDoubleValue wrap(IMekanismConfig config, ForgeConfigSpec.ConfigValue<Double> internal) {
        return new CachedDoubleValue(config, internal);
    }

    public double getOrDefault() {
        if (this.resolved || this.isLoaded()) {
            return this.get();
        }
        return (Double)this.internal.getDefault();
    }

    public double get() {
        if (!this.resolved) {
            this.cachedValue = (Double)this.internal.get();
            this.resolved = true;
        }
        return this.cachedValue;
    }

    @Override
    public double getAsDouble() {
        return this.get();
    }

    public void set(double value) {
        this.internal.set((Object)value);
        this.cachedValue = value;
    }

    @Override
    protected boolean clearCachedValue(boolean checkChanged) {
        if (!this.resolved) {
            return false;
        }
        double oldCachedValue = this.cachedValue;
        this.resolved = false;
        return checkChanged && oldCachedValue != this.get();
    }
}

