/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.energy;

import java.util.function.Supplier;
import mekanism.api.RelativeSide;
import mekanism.api.energy.IEnergyContainer;
import mekanism.common.capabilities.holder.energy.ConfigEnergyContainerHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHolder;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.tile.component.TileComponentConfig;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;

public class EnergyContainerHelper {
    private final IEnergyContainerHolder slotHolder;
    private boolean built;

    private EnergyContainerHelper(IEnergyContainerHolder slotHolder) {
        this.slotHolder = slotHolder;
    }

    public static EnergyContainerHelper forSide(Supplier<Direction> facingSupplier) {
        return new EnergyContainerHelper(new EnergyContainerHolder(facingSupplier));
    }

    public static EnergyContainerHelper forSideWithConfig(Supplier<Direction> facingSupplier, Supplier<TileComponentConfig> configSupplier) {
        return new EnergyContainerHelper(new ConfigEnergyContainerHolder(facingSupplier, configSupplier));
    }

    public <CONTAINER extends IEnergyContainer> CONTAINER addContainer(@NotNull CONTAINER container) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        IEnergyContainerHolder iEnergyContainerHolder = this.slotHolder;
        if (iEnergyContainerHolder instanceof EnergyContainerHolder) {
            EnergyContainerHolder slotHolder = (EnergyContainerHolder)iEnergyContainerHolder;
            slotHolder.addContainer(container, new RelativeSide[0]);
        } else {
            iEnergyContainerHolder = this.slotHolder;
            if (iEnergyContainerHolder instanceof ConfigEnergyContainerHolder) {
                ConfigEnergyContainerHolder slotHolder = (ConfigEnergyContainerHolder)iEnergyContainerHolder;
                slotHolder.addContainer(container);
            } else {
                throw new IllegalArgumentException("Holder does not know how to add containers");
            }
        }
        return container;
    }

    public <CONTAINER extends IEnergyContainer> CONTAINER addContainer(@NotNull CONTAINER container, RelativeSide ... sides) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        IEnergyContainerHolder iEnergyContainerHolder = this.slotHolder;
        if (!(iEnergyContainerHolder instanceof EnergyContainerHolder)) {
            throw new IllegalArgumentException("Holder does not know how to add containers on specific sides");
        }
        EnergyContainerHolder slotHolder = (EnergyContainerHolder)iEnergyContainerHolder;
        slotHolder.addContainer(container, sides);
        return container;
    }

    public IEnergyContainerHolder build() {
        this.built = true;
        return this.slotHolder;
    }
}

