/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.inventory.warning.WarningTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IGuiWrapper {
    default public void displayTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, Component ... components) {
        this.displayTooltips(guiGraphics, mouseX, mouseY, List.of(components));
    }

    default public void displayTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, List<Component> components) {
        guiGraphics.m_280666_(this.getFont(), components, mouseX, mouseY);
    }

    @NotNull
    default public ItemStack getCarriedItem() {
        IGuiWrapper iGuiWrapper = this;
        if (iGuiWrapper instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen = (AbstractContainerScreen)iGuiWrapper;
            return screen.m_6262_().m_142621_();
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player == null ? ItemStack.f_41583_ : player.f_36096_.m_142621_();
    }

    default public int getLeft() {
        IGuiWrapper iGuiWrapper = this;
        if (iGuiWrapper instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen = (AbstractContainerScreen)iGuiWrapper;
            return screen.getGuiLeft();
        }
        return 0;
    }

    default public int getTop() {
        IGuiWrapper iGuiWrapper = this;
        if (iGuiWrapper instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen = (AbstractContainerScreen)iGuiWrapper;
            return screen.getGuiTop();
        }
        return 0;
    }

    default public int getWidth() {
        IGuiWrapper iGuiWrapper = this;
        if (iGuiWrapper instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen = (AbstractContainerScreen)iGuiWrapper;
            return screen.getXSize();
        }
        return 0;
    }

    default public int getHeight() {
        IGuiWrapper iGuiWrapper = this;
        if (iGuiWrapper instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen = (AbstractContainerScreen)iGuiWrapper;
            return screen.getYSize();
        }
        return 0;
    }

    default public void addWindow(GuiWindow window) {
        Mekanism.logger.error("Tried to call 'addWindow' but unsupported in {}", (Object)this.getClass().getName());
    }

    default public void removeWindow(GuiWindow window) {
        Mekanism.logger.error("Tried to call 'removeWindow' but unsupported in {}", (Object)this.getClass().getName());
    }

    default public boolean currentlyQuickCrafting() {
        return false;
    }

    @Nullable
    default public GuiWindow getWindowHovering(double mouseX, double mouseY) {
        return null;
    }

    @NotNull
    default public BooleanSupplier trackWarning(@NotNull WarningTracker.WarningType type, @NotNull BooleanSupplier warningSupplier) {
        Mekanism.logger.error("Tried to call 'trackWarning' but unsupported in {}", (Object)this.getClass().getName());
        return warningSupplier;
    }

    public Font getFont();

    default public void renderItem(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis) {
        this.renderItem(guiGraphics, stack, xAxis, yAxis, 1.0f);
    }

    default public void renderItem(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis, float scale) {
        GuiUtils.renderItem(guiGraphics, stack, xAxis, yAxis, scale, this.getFont(), null, false);
    }

    default public void renderItemTooltip(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis) {
        guiGraphics.m_280153_(this.getFont(), stack, xAxis, yAxis);
    }

    default public void renderItemTooltipWithExtra(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis, List<Component> toAppend) {
        if (toAppend.isEmpty()) {
            this.renderItemTooltip(guiGraphics, stack, xAxis, yAxis);
        } else {
            ArrayList<Component> tooltip = new ArrayList<Component>(Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)stack));
            tooltip.addAll(toAppend);
            guiGraphics.renderTooltip(this.getFont(), tooltip, stack.m_150921_(), stack, xAxis, yAxis);
        }
    }

    default public void renderItemWithOverlay(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis, float scale, @Nullable String text) {
        GuiUtils.renderItem(guiGraphics, stack, xAxis, yAxis, scale, this.getFont(), text, true);
    }

    default public void setSelectedWindow(SelectedWindowData selectedWindow) {
        Mekanism.logger.error("Tried to call 'setSelectedWindow' but unsupported in {}", (Object)this.getClass().getName());
    }

    default public void addFocusListener(GuiElement element) {
        Mekanism.logger.error("Tried to call 'addFocusListener' but unsupported in {}", (Object)this.getClass().getName());
    }

    default public void removeFocusListener(GuiElement element) {
        Mekanism.logger.error("Tried to call 'removeFocusListener' but unsupported in {}", (Object)this.getClass().getName());
    }

    default public void focusChange(GuiElement changed) {
        Mekanism.logger.error("Tried to call 'focusChange' but unsupported in {}", (Object)this.getClass().getName());
    }

    default public void incrementFocus(GuiElement current) {
        Mekanism.logger.error("Tried to call 'incrementFocus' but unsupported in {}", (Object)this.getClass().getName());
    }
}

