/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.mixin;

import com.connectivity.Connectivity;
import com.connectivity.config.CommonConfiguration;
import com.google.common.base.Charsets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryPacket;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ConnectionProtocol.PacketSet.class})
public class ConnectionProtocolMixin<T extends PacketListener> {
    @Shadow
    @Final
    public List<Function<FriendlyByteBuf, ? extends Packet<T>>> f_178326_;
    @Shadow
    @Final
    public Object2IntMap<Class<? extends Packet<T>>> f_129604_;

    @Inject(method={"addPacket"}, at={@At(value="HEAD")}, cancellable=true)
    public <P extends Packet<T>> void onAdd(Class<P> pClass, Function<FriendlyByteBuf, P> byteBufPFunction, CallbackInfoReturnable cir) {
        int i;
        int j;
        if (pClass == ServerboundCustomQueryPacket.class && ((CommonConfiguration)Connectivity.config.getCommonConfig()).disableLoginLimits) {
            byteBufPFunction = buf -> {
                int transactionId = buf.m_130242_();
                FriendlyByteBuf data = null;
                if (buf.readBoolean()) {
                    int bytes = buf.readableBytes();
                    if ((bytes < 0 || bytes > 0x100000) && ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                        this.reportData(pClass, (FriendlyByteBuf)buf);
                    }
                    data = new FriendlyByteBuf(buf.readBytes(bytes));
                }
                return new ServerboundCustomQueryPacket(transactionId, data);
            };
        }
        if (pClass == ClientboundCustomQueryPacket.class && ((CommonConfiguration)Connectivity.config.getCommonConfig()).disableLoginLimits) {
            byteBufPFunction = buf -> {
                int transactionId = buf.m_130242_();
                ResourceLocation identifier = buf.m_130281_();
                int bytes = buf.readableBytes();
                if ((bytes < 0 || bytes > 0x100000) && ((CommonConfiguration)Connectivity.config.getCommonConfig()).debugPrintMessages) {
                    this.reportData(pClass, (FriendlyByteBuf)buf);
                }
                FriendlyByteBuf data = new FriendlyByteBuf(buf.readBytes(bytes));
                return new ClientboundCustomQueryPacket(transactionId, identifier, data);
            };
        }
        if ((j = this.f_129604_.put(pClass, i = this.f_178326_.size())) != -1) {
            String s = "Packet " + pClass + " is already registered to ID " + j;
            Connectivity.LOGGER.error(s);
            throw new IllegalArgumentException(s);
        }
        this.f_178326_.add(byteBufPFunction);
        cir.setReturnValue((Object)this);
    }

    private void reportData(Class pClass, FriendlyByteBuf data) {
        Connectivity.LOGGER.warn("Too big payload data for class:" + pClass.getSimpleName() + " bytes:" + data.readableBytes());
        Connectivity.LOGGER.warn("Data:" + data.toString(Charsets.UTF_8));
    }
}

