/*
 * Decompiled with CFR 0.152.
 */
package com.connectivity.logging;

import com.connectivity.Connectivity;
import com.connectivity.logging.BlockEntityTypeHandler;
import com.connectivity.logging.ByteArraySerializer;
import com.connectivity.logging.ByteBufferTypeHandler;
import com.connectivity.logging.DoubleArraySerializer;
import com.connectivity.logging.EntityTypeHandler;
import com.connectivity.logging.FloatArraySerializer;
import com.connectivity.logging.FriendlyBufferTypeHandler;
import com.connectivity.logging.GsonErrorHandling;
import com.connectivity.logging.GsonOptionalTypeHandler;
import com.connectivity.logging.HolderReferenceTypeHandler;
import com.connectivity.logging.IntArraySerializer;
import com.connectivity.logging.IterableTypeHandler;
import com.connectivity.logging.LongArraySerializer;
import com.connectivity.logging.RecipeTypeHandler;
import com.connectivity.networkstats.IWrappedPacket;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ReflectionAccessFilter;
import com.google.gson.TypeAdapterFactory;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class PacketLogging {
    private static Object lastPacket = null;

    public static final Gson getGson() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().addReflectionAccessFilter(ReflectionAccessFilter.BLOCK_INACCESSIBLE_JAVA).registerTypeAdapterFactory((TypeAdapterFactory)new GsonErrorHandling()).registerTypeHierarchyAdapter(Optional.class, new GsonOptionalTypeHandler()).registerTypeHierarchyAdapter(EntityType.class, new EntityTypeHandler()).registerTypeHierarchyAdapter(BlockEntityType.class, (Object)new BlockEntityTypeHandler()).registerTypeHierarchyAdapter(ByteBuf.class, new ByteBufferTypeHandler()).registerTypeHierarchyAdapter(FriendlyByteBuf.class, new FriendlyBufferTypeHandler()).registerTypeHierarchyAdapter(Holder.Reference.class, new HolderReferenceTypeHandler()).registerTypeHierarchyAdapter(Holder.Reference.class, new HolderReferenceTypeHandler()).addSerializationExclusionStrategy(new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                return f.getDeclaredType() instanceof Registry || f.getDeclaredType() instanceof Holder;
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return clazz.isInstance(Registry.class) || clazz.isInstance(Holder.class) || clazz.getName().contains("jdk.internal");
            }
        }).registerTypeHierarchyAdapter(int[].class, (Object)new IntArraySerializer()).registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArraySerializer()).registerTypeHierarchyAdapter(double[].class, (Object)new DoubleArraySerializer()).registerTypeHierarchyAdapter(float[].class, (Object)new FloatArraySerializer()).registerTypeHierarchyAdapter(long[].class, (Object)new LongArraySerializer()).registerTypeHierarchyAdapter(Iterable.class, new IterableTypeHandler()).registerTypeAdapter(Recipe.class, (Object)new RecipeTypeHandler()).create();
    }

    public static void logPacket(Object packet) {
        PacketLogging.logPacket(packet, "");
    }

    public static void logPacket(Object packet, String warning) {
        if (packet == lastPacket) {
            return;
        }
        lastPacket = packet;
        Object orgPacket = packet;
        if (packet instanceof IWrappedPacket && ((IWrappedPacket)packet).getOriginalMsg() != null) {
            orgPacket = ((IWrappedPacket)packet).getOriginalMsg();
        }
        String name = orgPacket.getClass().getSimpleName();
        Connectivity.LOGGER.warn("Packet:" + name + " " + warning);
        try {
            Connectivity.LOGGER.warn("Packet data:\n" + PacketLogging.getGson().toJson(orgPacket));
        }
        catch (Throwable e) {
            Connectivity.LOGGER.warn("Failed to print data for packet", e);
        }
    }
}

