/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.event;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.client.render.item.JarBlockItemRenderer;
import cy.jdkdigital.productivebees.common.block.SolitaryNest;
import cy.jdkdigital.productivebees.common.block.nest.WoodNest;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.entity.bee.solitary.BlueBandedBee;
import cy.jdkdigital.productivebees.common.recipe.BeeFishingRecipe;
import cy.jdkdigital.productivebees.compat.jei.ingredients.BeeIngredient;
import cy.jdkdigital.productivebees.gen.feature.WoodNestDecorator;
import cy.jdkdigital.productivebees.handler.bee.IInhabitantStorage;
import cy.jdkdigital.productivebees.init.ModAdvancements;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModConfiguredFeatures;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModProfessions;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="productivebees")
public class EventHandler {
    @SubscribeEvent
    public static void onBlockGrow(SaplingGrowTreeEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            Block feature;
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            WoodNestDecorator decorator = null;
            float r = serverLevel.m_213780_().m_188501_();
            boolean canSpawnNest = EventHandler.hasFlowers(event.getLevel(), event.getPos()) && (double)r < (Double)ProductiveBeesConfig.WORLD_GEN.treeGrowNestChance.get();
            Block grownBlock = serverLevel.m_8055_(event.getPos()).m_60734_();
            if (canSpawnNest && grownBlock.equals(Blocks.f_50746_)) {
                decorator = new WoodNestDecorator(((Block)ModBlocks.OAK_WOOD_NEST.get()).m_49966_());
            } else if (canSpawnNest && grownBlock.equals(Blocks.f_50748_)) {
                decorator = new WoodNestDecorator(((Block)ModBlocks.BIRCH_WOOD_NEST.get()).m_49966_());
            } else if (canSpawnNest && grownBlock.equals(Blocks.f_50747_)) {
                decorator = new WoodNestDecorator(((Block)ModBlocks.SPRUCE_WOOD_NEST.get()).m_49966_());
            } else if (canSpawnNest && grownBlock.equals(Blocks.f_50750_)) {
                decorator = new WoodNestDecorator(((Block)ModBlocks.ACACIA_WOOD_NEST.get()).m_49966_());
            } else if (canSpawnNest && grownBlock.equals(Blocks.f_50751_)) {
                decorator = new WoodNestDecorator(((Block)ModBlocks.DARK_OAK_WOOD_NEST.get()).m_49966_());
            } else if (canSpawnNest && grownBlock.equals(Blocks.f_50749_)) {
                decorator = new WoodNestDecorator(((Block)ModBlocks.JUNGLE_WOOD_NEST.get()).m_49966_());
            } else if (canSpawnNest && grownBlock.equals(Blocks.f_271334_)) {
                decorator = new WoodNestDecorator(((Block)ModBlocks.CHERRY_WOOD_NEST.get()).m_49966_());
            } else if (canSpawnNest && grownBlock.equals(Blocks.f_220831_)) {
                decorator = new WoodNestDecorator(((Block)ModBlocks.MANGROVE_WOOD_NEST.get()).m_49966_());
            } else if ((double)r < (Double)ProductiveBeesConfig.WORLD_GEN.treeGrowNestChance.get() && (grownBlock.equals(Blocks.f_50700_) || grownBlock.equals(Blocks.f_50691_))) {
                ResourceKey<ConfiguredFeature<?, ?>> featureKey = grownBlock.equals(Blocks.f_50700_) ? ModConfiguredFeatures.CRIMSON_FUNGUS_BEES_GROWN : ModConfiguredFeatures.WARPED_FUNGUS_BEES_GROWN;
                feature = event.getLevel().m_9598_().m_175515_(Registries.f_256911_).m_203636_(featureKey).orElse(null);
                event.setFeature((Holder)feature);
            }
            if (decorator != null) {
                feature = decorator.getNest().m_60734_();
                if (feature instanceof WoodNest) {
                    WoodNest woodNest = (WoodNest)feature;
                    decorator.setBeeRecipes(SolitaryNest.getSpawningRecipes(woodNest, (Level)serverLevel, (Holder<Biome>)serverLevel.m_204166_(event.getPos()), ItemStack.f_41583_));
                }
                Holder feature2 = event.getFeature();
                WoodNestDecorator finalDecorator = decorator;
                ((ConfiguredFeature)feature2.m_203334_()).m_65398_().forEach(configuredFeature -> {
                    FeatureConfiguration patt6790$temp = configuredFeature.f_65378_();
                    if (patt6790$temp instanceof TreeConfiguration) {
                        TreeConfiguration treeConfig = (TreeConfiguration)patt6790$temp;
                        ArrayList<TreeDecorator> decorators = new ArrayList<TreeDecorator>(treeConfig.f_68187_);
                        decorators.add(finalDecorator);
                        treeConfig.f_68187_ = decorators;
                    }
                });
                event.setFeature(feature2);
            }
        }
    }

    private static boolean hasFlowers(LevelAccessor pLevel, BlockPos pPos) {
        for (BlockPos blockpos : BlockPos.MutableBlockPos.m_121940_((BlockPos)pPos.m_7495_().m_122013_(2).m_122025_(2), (BlockPos)pPos.m_7494_().m_122020_(2).m_122030_(2))) {
            BlockState state = pLevel.m_8055_(blockpos);
            if (!state.m_204336_(BlockTags.f_13041_) || state.m_204336_(ModTags.NOT_FLOWERS)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onWandererTradesEvent(WandererTradesEvent event) {
        event.getGenericTrades().add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 10), ItemStack.f_41583_, new ItemStack((ItemLike)ModItems.STURDY_BEE_CAGE.get()), 1, 12, 6, 0.2f));
        event.getGenericTrades().add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 24), ItemStack.f_41583_, new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_bumble_bee"))), 3, 12, 6, 0.2f));
    }

    @SubscribeEvent
    public static void onVillagerTradesEvent(VillagerTradesEvent event) {
        if (event.getType().equals(ModProfessions.BEEKEEPER.get())) {
            ((List)event.getTrades().get(1)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42781_), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42616_), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(1)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42590_, 4), 1, 32, 3, 0.2f));
            ((List)event.getTrades().get(1)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 3), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42574_), 3, 12, 3, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42787_, 2), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42616_), 3, 10, 6, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), ItemStack.f_41583_, new ItemStack((ItemLike)ModItems.BEE_CAGE.get(), 4), 3, 64, 6, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 2), ItemStack.f_41583_, new ItemStack((ItemLike)ModItems.SUGARBAG_HONEYCOMB.get()), 3, 32, 3, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), ItemStack.f_41583_, new ItemStack((ItemLike)ModItems.TREAT_ON_A_STICK.get()), 3, 8, 3, 0.2f));
            ((List)event.getTrades().get(2)).add((trader, rand) -> {
                if (rand.m_188499_()) {
                    return new MerchantOffer(new ItemStack((ItemLike)ModItems.HONEY_TREAT.get(), 4), ItemStack.f_41583_, new ItemStack((ItemLike)Items.f_42616_), 3, 50, 3, 0.2f);
                }
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), ItemStack.f_41583_, new ItemStack((ItemLike)ModItems.HONEY_TREAT.get(), 2), 3, 100, 3, 0.2f);
            });
            ArrayList<Block> hiveMap = new ArrayList<Block>(){
                {
                    this.add((Block)ModBlocks.HIVES.get("advanced_jungle_beehive").get());
                    this.add((Block)ModBlocks.HIVES.get("advanced_acacia_beehive").get());
                    this.add((Block)ModBlocks.HIVES.get("advanced_birch_beehive").get());
                    this.add((Block)ModBlocks.HIVES.get("advanced_dark_oak_beehive").get());
                    this.add((Block)ModBlocks.HIVES.get("advanced_mangrove_beehive").get());
                    this.add((Block)ModBlocks.HIVES.get("advanced_spruce_beehive").get());
                    this.add((Block)ModBlocks.HIVES.get("advanced_cherry_beehive").get());
                    this.add((Block)ModBlocks.HIVES.get("advanced_oak_beehive").get());
                }
            };
            ArrayList<Block> boxMap = new ArrayList<Block>(){
                {
                    this.add((Block)ModBlocks.EXPANSIONS.get("expansion_box_jungle").get());
                    this.add((Block)ModBlocks.EXPANSIONS.get("expansion_box_acacia").get());
                    this.add((Block)ModBlocks.EXPANSIONS.get("expansion_box_birch").get());
                    this.add((Block)ModBlocks.EXPANSIONS.get("expansion_box_dark_oak").get());
                    this.add((Block)ModBlocks.EXPANSIONS.get("expansion_box_mangrove").get());
                    this.add((Block)ModBlocks.EXPANSIONS.get("expansion_box_spruce").get());
                    this.add((Block)ModBlocks.EXPANSIONS.get("expansion_box_cherry").get());
                    this.add((Block)ModBlocks.EXPANSIONS.get("expansion_box_oak").get());
                }
            };
            AtomicInteger picked = new AtomicInteger();
            ((List)event.getTrades().get(3)).add((trader, rand) -> {
                picked.set(rand.m_188503_(hiveMap.size()));
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42786_, 1), new ItemStack((ItemLike)Items.f_42616_, 6), new ItemStack((ItemLike)hiveMap.get(picked.get())), 1, 12, 6, 0.2f);
            });
            ((List)event.getTrades().get(3)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4), ItemStack.f_41583_, new ItemStack((ItemLike)boxMap.get(picked.get())), 1, 12, 6, 0.2f));
            ((List)event.getTrades().get(4)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 12), new ItemStack((ItemLike)ModItems.BEE_CAGE.get(), 1), new ItemStack((ItemLike)ModItems.STURDY_BEE_CAGE.get()), 3, 12, 6, 0.2f));
            ((List)event.getTrades().get(4)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 6), ItemStack.f_41583_, new ItemStack((ItemLike)ModBlocks.JAR.get(), 1), 2, 12, 8, 0.2f));
            ((List)event.getTrades().get(5)).add((trader, rand) -> {
                ItemStack nest = new ItemStack((ItemLike)Items.f_42785_);
                try {
                    CompoundTag tag = nest.m_41784_();
                    CompoundTag bees = TagParser.m_129359_((String)"{Bees:[{EntityData:{id:\"minecraft:bee\"},TicksInHive:0,MinOccupationTicks:0}]}");
                    tag.m_128365_("BlockEntityTag", (Tag)bees);
                }
                catch (CommandSyntaxException e) {
                    ProductiveBees.LOGGER.warn("Failed to put bees into the beekeepers nests :(" + e.getMessage());
                }
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 32), ItemStack.f_41583_, nest, 1, 3, 16, 0.2f);
            });
            ((List)event.getTrades().get(5)).add((trader, rand) -> {
                Item egg = switch (rand.m_188503_(7)) {
                    case 0 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_quarry_bee"));
                    case 1 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_rancher_bee"));
                    case 2 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_farmer_bee"));
                    case 3 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_cupid_bee"));
                    case 4 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_collector_bee"));
                    case 5 -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_dye_bee"));
                    default -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivebees", "spawn_egg_lumber_bee"));
                };
                return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 24), ItemStack.f_41583_, new ItemStack((ItemLike)egg), 3, 12, 6, 0.2f);
            });
        }
    }

    @SubscribeEvent
    public static void entityRightClicked(PlayerInteractEvent.EntityInteract entityInteract) {
        Level world;
        ItemStack itemStack = entityInteract.getItemStack();
        Entity entity = entityInteract.getTarget();
        if (!itemStack.m_41619_() && entity instanceof Bee && (world = entityInteract.getLevel()) instanceof ServerLevel) {
            Player player = entityInteract.getEntity();
            BlockPos pos = entity.m_20183_();
            Entity newBee = BeeHelper.itemInteract((Bee)entity, itemStack, (ServerLevel)world, entity.serializeNBT(), player);
            if (newBee instanceof Bee) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 0.2, 0.1, 0.2);
                world.m_6263_(player, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11698_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                world.m_7967_(newBee);
                if (((Bee)entity).m_21523_()) {
                    ((Bee)entity).m_21455_(true, true);
                }
                entity.m_146870_();
            }
        }
    }

    @SubscribeEvent
    public static void cocoaBreakSpawn(BlockEvent.BreakEvent event) {
        Player player;
        Level level;
        if (event.getState().m_60734_().equals(Blocks.f_50262_) && (Integer)event.getState().m_61143_((Property)CocoaBlock.f_51736_) == 2 && (level = (player = event.getPlayer()).m_9236_()) instanceof ServerLevel && player instanceof ServerPlayer && (double)level.f_46441_.m_188501_() < (Double)ProductiveBeesConfig.BEES.sugarbagBeeChance.get()) {
            ConfigurableBee bee = (ConfigurableBee)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).m_20615_(level);
            BlockPos pos = event.getPos();
            if (bee != null && BeeReloadListener.INSTANCE.getData("productivebees:sugarbag") != null) {
                bee.setBeeType("productivebees:sugarbag");
                bee.setDefaultAttributes();
                bee.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, bee.m_146908_(), bee.m_146909_());
                level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 0.2, 0.1, 0.2);
                level.m_5594_(player, pos, SoundEvents.f_11698_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                level.m_7967_((Entity)bee);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttributeCreate(EntityAttributeCreationEvent event) {
        EntityType bee;
        for (RegistryObject registryObject : ModEntities.HIVE_BEES.getEntries()) {
            bee = (EntityType)registryObject.get();
            event.put(bee, Bee.m_27858_().m_22265_());
        }
        for (RegistryObject registryObject : ModEntities.SOLITARY_BEES.getEntries()) {
            bee = (EntityType)registryObject.get();
            if (bee.m_20675_().contains("blue_banded_bee")) continue;
            event.put(bee, Bee.m_27858_().m_22265_());
        }
        event.put((EntityType)ModEntities.BLUE_BANDED_BEE.get(), BlueBandedBee.getDefaultAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void fuelValues(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().m_41720_();
        if (item.equals(ModItems.WAX.get())) {
            event.setBurnTime(100);
        } else if (item.equals(((Block)ModBlocks.WAX_BLOCK.get()).m_5456_())) {
            event.setBurnTime(900);
        }
    }

    @SubscribeEvent
    public static void onItemFished(ItemFishedEvent event) {
        Player player = event.getEntity();
        if (player != null && !(player instanceof FakePlayer)) {
            BlockPos pos = event.getHookEntity().m_20183_();
            Biome fishingBiome = (Biome)player.m_9236_().m_204166_(pos).m_203334_();
            ArrayList<BeeFishingRecipe> possibleRecipes = new ArrayList<BeeFishingRecipe>();
            List<BeeFishingRecipe> recipes = BeeFishingRecipe.getRecipeList(fishingBiome, player.m_9236_());
            if (!recipes.isEmpty()) {
                for (BeeFishingRecipe recipe : recipes) {
                    boolean willSpawn = player.m_9236_().f_46441_.m_188500_() < recipe.chance;
                    int fishingLuck = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44953_, (ItemStack)player.m_21205_());
                    for (int i = 0; i < 1 + fishingLuck; ++i) {
                        willSpawn = willSpawn || player.m_9236_().f_46441_.m_188500_() < recipe.chance;
                    }
                    if (!willSpawn) continue;
                    possibleRecipes.add(recipe);
                }
            }
            if (!possibleRecipes.isEmpty()) {
                BeeFishingRecipe chosenRecipe = (BeeFishingRecipe)possibleRecipes.get(player.m_9236_().f_46441_.m_188503_(possibleRecipes.size()));
                BeeIngredient beeIngredient = (BeeIngredient)chosenRecipe.output.get();
                Bee bee = (Bee)beeIngredient.getBeeEntity().m_20615_(player.m_9236_());
                if (bee != null) {
                    if (bee instanceof ConfigurableBee) {
                        ConfigurableBee configBee = (ConfigurableBee)bee;
                        configBee.setBeeType(beeIngredient.getBeeType().toString());
                        configBee.setDefaultAttributes();
                    }
                    bee.m_7678_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, bee.m_146908_(), bee.m_146909_());
                    player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), 0.2, 0.1, 0.2);
                    player.m_9236_().m_5594_(player, pos, SoundEvents.f_11741_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    player.m_9236_().m_7967_((Entity)bee);
                    bee.m_6710_((LivingEntity)player);
                    ModAdvancements.FISH_BEE.trigger((ServerPlayer)player, bee);
                }
            }
        }
    }

    @SubscribeEvent
    public static void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(IInhabitantStorage.class);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Iterator<Entity> iter = JarBlockItemRenderer.beeEntities.values().iterator();
        while (iter.hasNext()) {
            Entity bee = iter.next();
            ++bee.f_19797_;
            if (bee.f_19797_ % 6120 != 0) continue;
            iter.remove();
        }
    }

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.loadedFromDisk() && event.getLevel() instanceof ServerLevel && (entity = event.getEntity()) instanceof ProductiveBee) {
            ProductiveBee entity2 = (ProductiveBee)entity;
            entity2.setDefaultAttributes();
        }
    }
}

