/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.datagen;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivelib.loot.OptionalLootItem;
import cy.jdkdigital.productivelib.loot.condition.OptionalCopyBlockState;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class BlockLootProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private final List<LootTableProvider.SubProviderEntry> subProviders;
    private static final LootItemCondition.Builder SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));

    public BlockLootProvider(PackOutput packOutput, List<LootTableProvider.SubProviderEntry> providers) {
        this.pathProvider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "loot_tables");
        this.subProviders = providers;
    }

    public String m_6055_() {
        return "Productive Bees Block Loot Table datagen";
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        HashMap map = Maps.newHashMap();
        this.subProviders.forEach(providerEntry -> ((LootTableSubProvider)providerEntry.f_243941_().get()).m_245126_((resourceLocation, builder) -> {
            builder.m_287223_(resourceLocation);
            if (map.put(resourceLocation, builder.m_79165_(providerEntry.f_244144_()).m_79167_()) != null) {
                throw new IllegalStateException("Duplicate loot table " + resourceLocation);
            }
        }));
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> DataProvider.m_253162_((CachedOutput)cache, (JsonElement)LootDataType.f_278413_.m_278857_().toJsonTree(entry.getValue()), (Path)this.pathProvider.m_245731_((ResourceLocation)entry.getKey()))).toArray(CompletableFuture[]::new));
    }

    public static LootTable.Builder genHiveDrop(Block hive) {
        LootPoolSingletonContainer.Builder hiveNoHoney = ((LootPoolSingletonContainer.Builder)OptionalLootItem.lootTableItem((ItemLike)hive).m_79080_(ExplosionCondition.m_81661_())).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("BeeList", "BlockEntityTag.BeeList"));
        LootPoolSingletonContainer.Builder hiveHoney = ((LootPoolSingletonContainer.Builder)OptionalLootItem.lootTableItem((ItemLike)hive).m_79080_(SILK_TOUCH)).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("BeeList", "BlockEntityTag.BeeList")).m_79078_((LootItemFunction.Builder)OptionalCopyBlockState.copyState((Block)hive).copy((Property)BeehiveBlock.f_49564_));
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)hiveHoney.m_7170_((LootPoolEntryContainer.Builder)hiveNoHoney)));
    }

    public static LootTable.Builder genExpansionDrop(Block expansion) {
        LootPoolEntryContainer.Builder expansionBox = OptionalLootItem.lootTableItem((ItemLike)expansion).m_79080_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(expansionBox));
    }

    public static LootTable.Builder genBlockDrop(Block expansion) {
        LootPoolEntryContainer.Builder builder = LootItem.m_79579_((ItemLike)expansion).m_79080_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(builder));
    }

    public static class LootProvider
    extends BlockLootSubProvider {
        private final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();
        private List<Block> knownBlocks = new ArrayList<Block>();

        public LootProvider() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            HashMap tables = new HashMap();
            ModBlocks.HIVELIST.forEach((modid, strings) -> strings.forEach((name, type) -> {
                name = modid.equals("productivebees") ? name : modid + "_" + name;
                Block hive = (Block)ModBlocks.HIVES.get("advanced_" + name + "_beehive").get();
                Block box = (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + name).get();
                Function<Block, LootTable.Builder> hiveFunc = this.functionTable.getOrDefault(hive, BlockLootProvider::genHiveDrop);
                this.m_247577_(hive, hiveFunc.apply(hive));
                Function<Block, LootTable.Builder> expansionFunc = this.functionTable.getOrDefault(box, BlockLootProvider::genExpansionDrop);
                this.m_247577_(box, expansionFunc.apply(box));
            }));
            ModBlocks.hiveStyles.forEach(style -> {
                Block hive = (Block)ModBlocks.HIVES.get("advanced_" + style + "_canvas_beehive").get();
                Block box = (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + style + "_canvas").get();
                Function<Block, LootTable.Builder> hiveFunc = this.functionTable.getOrDefault(hive, BlockLootProvider::genHiveDrop);
                this.m_247577_(hive, hiveFunc.apply(hive));
                Function<Block, LootTable.Builder> expansionFunc = this.functionTable.getOrDefault(box, BlockLootProvider::genExpansionDrop);
                this.m_247577_(box, expansionFunc.apply(box));
            });
            Function<Block, LootTable.Builder> func = this.functionTable.getOrDefault(ModBlocks.PETRIFIED_HONEY.get(), BlockLootProvider::genBlockDrop);
            this.m_247577_((Block)ModBlocks.PETRIFIED_HONEY.get(), func.apply((Block)ModBlocks.PETRIFIED_HONEY.get()));
            ModBlocks.PETRIFIED_HONEY_BLOCKS.forEach(registryObject -> {
                Function<Block, LootTable.Builder> petrifiedFunc = this.functionTable.getOrDefault(registryObject.get(), BlockLootProvider::genBlockDrop);
                this.m_247577_((Block)registryObject.get(), petrifiedFunc.apply((Block)registryObject.get()));
            });
        }

        protected void m_247577_(Block block, LootTable.Builder builder) {
            super.m_247577_(block, builder);
            this.knownBlocks.add(block);
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }
    }
}

