/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container;

import cy.jdkdigital.productivebees.common.block.Catcher;
import cy.jdkdigital.productivebees.common.block.entity.CatcherBlockEntity;
import cy.jdkdigital.productivebees.container.AbstractContainer;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.container.ManualSlotItemHandler;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class CatcherContainer
extends AbstractContainer {
    public final CatcherBlockEntity tileEntity;
    public final ContainerLevelAccess canInteractWithCallable;

    public CatcherContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, CatcherContainer.getTileEntity(playerInventory, data));
    }

    public CatcherContainer(int windowId, Inventory playerInventory, CatcherBlockEntity tileEntity) {
        this((MenuType)ModContainerTypes.CATCHER.get(), windowId, playerInventory, tileEntity);
    }

    public CatcherContainer(@Nullable MenuType<?> type, int windowId, Inventory playerInventory, CatcherBlockEntity tileEntity) {
        super(type, windowId);
        this.tileEntity = tileEntity;
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)tileEntity.m_58904_(), (BlockPos)tileEntity.m_58899_());
        this.tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inv -> {
            this.m_38897_((Slot)new ManualSlotItemHandler((InventoryHandlerHelper.BlockEntityItemStackHandler)inv, 0, 13, 35));
            this.addSlotBox((IItemHandler)inv, InventoryHandlerHelper.OUTPUT_SLOTS[0], 67, 17, 3, 18, 3, 18);
        });
        this.tileEntity.getUpgradeHandler().ifPresent(upgradeHandler -> this.addSlotBox((IItemHandler)upgradeHandler, 0, 165, 8, 1, 18, 4, 18));
        this.layoutPlayerInventorySlots(playerInventory, 0, -5, 84);
    }

    private static CatcherBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity tileAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof CatcherBlockEntity) {
            return (CatcherBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public boolean m_6875_(@Nonnull Player player) {
        return (Boolean)this.canInteractWithCallable.m_39299_((world, pos) -> world.m_8055_(pos).m_60734_() instanceof Catcher && player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    @Override
    protected BlockEntity getBlockEntity() {
        return this.tileEntity;
    }
}

