/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemHandlerHelper;

public class FilteredItemStack
implements INBTSerializable<CompoundTag> {
    private ItemStack filter;
    private ItemStack actualStack = ItemStack.f_41583_;
    private int count = 0;
    private final int amountLimit;
    private final int unitWorth;
    private final boolean canRemove;

    public FilteredItemStack(Item filter, int amountLimit, int unitWorth, boolean canRemove) {
        this(new ItemStack((ItemLike)filter), amountLimit, unitWorth, canRemove);
    }

    FilteredItemStack(int amountLimit, boolean canRemove) {
        this(amountLimit, 1, canRemove);
    }

    FilteredItemStack(ItemStack filter, int amountLimit, boolean canRemove) {
        this(filter, amountLimit, 1, canRemove);
    }

    private FilteredItemStack(ItemStack filter, int amountLimit, int unitWorth, boolean canRemove) {
        this(amountLimit, unitWorth, canRemove);
        this.filter = filter.m_41777_();
        this.filter.m_41764_(1);
    }

    private FilteredItemStack(int amountLimit, int unitWorth, boolean canRemove) {
        this.amountLimit = amountLimit;
        this.unitWorth = unitWorth;
        this.canRemove = canRemove;
    }

    public ItemStack getFilterStack() {
        return this.filter;
    }

    public ItemStack getStack() {
        return this.actualStack;
    }

    public CompoundTag serializeNBT() {
        CompoundTag ret = new CompoundTag();
        ret.m_128365_("filter", (Tag)this.filter.serializeNBT());
        ret.m_128405_("amount", this.count);
        return ret;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.filter = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("filter"));
        this.count = nbt.m_128451_("amount");
        this.actualStack = this.filter.m_41777_();
        this.actualStack.m_41764_(this.worthToUnits(this.count));
    }

    void setCount(int count) {
        this.count = count;
        int units = this.worthToUnits(this.count);
        if (units == 0) {
            this.actualStack = ItemStack.f_41583_;
            return;
        }
        if (units > 0 && this.actualStack.m_41619_()) {
            this.actualStack = this.filter.m_41777_();
        }
        this.actualStack.m_41764_(units);
    }

    ItemStack insertItem(ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        int remainingTotal = this.worthToUnits(this.amountLimit - this.count);
        if (remainingTotal <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > remainingTotal;
        if (!simulate) {
            this.setCount(this.count + this.unitsToWorth(reachedLimit ? remainingTotal : stack.m_41613_()));
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - remainingTotal)) : ItemStack.f_41583_;
    }

    public boolean isEmpty() {
        return this.count <= 0;
    }

    private int worthToUnits(int valueWorth) {
        return valueWorth / this.unitWorth;
    }

    int unitsToWorth(int valueUnits) {
        return this.unitWorth * valueUnits;
    }

    public int getCount() {
        return this.count;
    }

    public boolean canRemove() {
        return this.canRemove;
    }
}

