/*
 * Decompiled with CFR 0.152.
 */
package reliquary.init;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.fml.ModList;
import reliquary.compat.botania.BotaniaCompat;
import reliquary.compat.curios.CuriosCompat;
import reliquary.compat.tconstruct.TConstructCompat;
import reliquary.util.LogHelper;

public class ModCompat {
    private static final Map<String, Supplier<Runnable>> compatFactories = new HashMap<String, Supplier<Runnable>>();

    private ModCompat() {
    }

    public static void initCompats() {
        for (Map.Entry<String, Supplier<Runnable>> entry : compatFactories.entrySet()) {
            if (!ModList.get().isLoaded(entry.getKey())) continue;
            try {
                entry.getValue().get().run();
            }
            catch (Exception e) {
                LogHelper.error("Error instantiating compatibility ", e);
            }
        }
    }

    static {
        compatFactories.put("curios", () -> CuriosCompat::new);
        compatFactories.put("botania", () -> BotaniaCompat::new);
        compatFactories.put("tconstruct", () -> TConstructCompat::new);
    }
}

