/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import reliquary.crafting.AlkahestryRecipeRegistry;
import reliquary.init.ModItems;
import reliquary.items.AlkahestryTomeItem;

public class AlkahestryChargingRecipe
implements CraftingRecipe {
    private final Ingredient chargingIngredient;
    private final int chargeToAdd;
    private final ItemStack recipeOutput;
    private final ResourceLocation id;
    private final Ingredient tomeIngredient;

    private AlkahestryChargingRecipe(ResourceLocation id, Ingredient chargingIngredient, int chargeToAdd) {
        this.id = id;
        this.chargingIngredient = chargingIngredient;
        this.chargeToAdd = chargeToAdd;
        this.tomeIngredient = new TomeIngredient(chargeToAdd);
        this.recipeOutput = new ItemStack((ItemLike)ModItems.ALKAHESTRY_TOME.get());
        AlkahestryTomeItem.addCharge(this.recipeOutput, chargeToAdd);
        AlkahestryRecipeRegistry.registerChargingRecipe(this);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        ItemStack tome = ItemStack.f_41583_;
        int numberOfIngredients = 0;
        for (int x = 0; x < inv.m_6643_(); ++x) {
            ItemStack slotStack = inv.m_8020_(x);
            if (slotStack.m_41619_()) continue;
            boolean inRecipe = false;
            if (this.chargingIngredient.test(slotStack)) {
                inRecipe = true;
                ++numberOfIngredients;
            } else if (tome.m_41619_()) {
                inRecipe = true;
                tome = slotStack;
            }
            if (inRecipe) continue;
            return false;
        }
        return numberOfIngredients > 0 && tome.m_150930_((Item)ModItems.ALKAHESTRY_TOME.get()) && AlkahestryTomeItem.getCharge(tome) + this.chargeToAdd * numberOfIngredients <= AlkahestryTomeItem.getChargeLimit();
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        int numberOfIngredients = 0;
        ItemStack tome = ItemStack.f_41583_;
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack stack = inv.m_8020_(slot);
            if (this.chargingIngredient.test(stack)) {
                ++numberOfIngredients;
                continue;
            }
            if (stack.m_41720_() != ModItems.ALKAHESTRY_TOME.get()) continue;
            tome = stack.m_41777_();
        }
        AlkahestryTomeItem.addCharge(tome, this.chargeToAdd * numberOfIngredients);
        return tome;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.chargingIngredient, this.tomeIngredient});
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.recipeOutput;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModItems.ALKAHESTRY_CHARGING_SERIALIZER.get();
    }

    public int getChargeToAdd() {
        return this.chargeToAdd;
    }

    public Ingredient getChargingIngredient() {
        return this.chargingIngredient;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }

    private static class TomeIngredient
    extends Ingredient {
        private final int chargeToAdd;

        private TomeIngredient(int chargeToAdd) {
            super(Stream.of(new Ingredient.ItemValue(new ItemStack((ItemLike)ModItems.ALKAHESTRY_TOME.get()))));
            this.chargeToAdd = chargeToAdd;
        }

        public boolean test(ItemStack stack) {
            return stack.m_150930_((Item)ModItems.ALKAHESTRY_TOME.get()) && AlkahestryTomeItem.getCharge(stack) + this.chargeToAdd <= AlkahestryTomeItem.getChargeLimit();
        }

        public boolean isSimple() {
            return false;
        }
    }

    public static class Serializer
    implements RecipeSerializer<AlkahestryChargingRecipe> {
        public AlkahestryChargingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            if (!json.has("ingredient")) {
                throw new JsonParseException("No ingredient for alkahestry charging recipe");
            }
            Ingredient ingredient = CraftingHelper.getIngredient((JsonElement)json.get("ingredient"), (boolean)false);
            int chargeToAdd = GsonHelper.m_13927_((JsonObject)json, (String)"charge");
            return new AlkahestryChargingRecipe(recipeId, ingredient, chargeToAdd);
        }

        @Nullable
        public AlkahestryChargingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new AlkahestryChargingRecipe(recipeId, Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.readInt());
        }

        public void toNetwork(FriendlyByteBuf buffer, AlkahestryChargingRecipe recipe) {
            recipe.chargingIngredient.m_43923_(buffer);
            buffer.writeInt(recipe.chargeToAdd);
        }
    }
}

