/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

class SortedNbtSubtypeInterpreter
implements IIngredientSubtypeInterpreter<ItemStack> {
    private final Set<String> keysToConsider;
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");

    SortedNbtSubtypeInterpreter(String ... keysToConsider) {
        this.keysToConsider = new HashSet<String>(Arrays.asList(keysToConsider));
    }

    public String apply(ItemStack itemStack, UidContext context) {
        CompoundTag nbtTagCompound = itemStack.m_41783_();
        return nbtTagCompound != null && !nbtTagCompound.m_128456_() ? this.getSortedCompoundString(nbtTagCompound, this.keysToConsider::contains) : "";
    }

    private String handleEscape(String keyName) {
        return SIMPLE_VALUE.matcher(keyName).matches() ? keyName : StringTag.m_129303_((String)keyName);
    }

    private String getSortedCompoundString(CompoundTag nbtTagCompound, Predicate<String> addKey) {
        StringBuilder stringbuilder = new StringBuilder("{");
        List<String> sortedKeys = nbtTagCompound.m_128431_().stream().filter(addKey).sorted().toList();
        for (String s : sortedKeys) {
            if (stringbuilder.length() != 1) {
                stringbuilder.append(',');
            }
            Tag nbtValue = nbtTagCompound.m_128423_(s);
            stringbuilder.append(this.handleEscape(s)).append(':').append(this.getNbtString(nbtValue));
        }
        return stringbuilder.append('}').toString();
    }

    private String getNbtString(Tag nbtValue) {
        if (nbtValue instanceof ListTag) {
            ListTag listTag = (ListTag)nbtValue;
            return this.getNbtListString(listTag);
        }
        if (nbtValue instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)nbtValue;
            return this.getSortedCompoundString(compoundTag, k -> true);
        }
        return nbtValue.toString();
    }

    private String getNbtListString(ListTag listNBT) {
        StringBuilder stringbuilder = new StringBuilder("[");
        for (int i = 0; i < listNBT.size(); ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(this.getNbtString(listNBT.get(i)));
        }
        return stringbuilder.append(']').toString();
    }
}

