/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.angelring.utils;

import net.minecraft.world.entity.player.Player;

public class ExperienceUtils {
    public static long getPlayerXP(Player player) {
        return (long)((float)ExperienceUtils.getExperienceForLevel(player.f_36078_) + player.f_36080_ * (float)player.m_36323_());
    }

    public static void addPlayerXP(Player player, int amount) {
        player.m_6756_(amount);
    }

    public static long xpBarCap(int level) {
        if (level >= 30) {
            return 112L + (long)(level - 30) * 9L;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7L + (long)level * 2L;
    }

    private static long sum(long n, long a0, long d) {
        return n * (2L * a0 + (n - 1L) * d) / 2L;
    }

    public static long getExperienceForLevel(long level) {
        if (level == 0L) {
            return 0L;
        }
        if (level <= 15L) {
            return ExperienceUtils.sum(level, 7L, 2L);
        }
        if (level <= 30L) {
            return 315L + ExperienceUtils.sum(level - 15L, 37L, 5L);
        }
        return 1395L + ExperienceUtils.sum(level - 30L, 112L, 9L);
    }

    public static long getLevelForExperience(long targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (long)(xpToNextLevel = (int)ExperienceUtils.xpBarCap(level))) {
            ++level;
            targetXp -= (long)xpToNextLevel;
        }
        return level;
    }

    public static float calculateStoredLevels(int storedXP) {
        float storedLevels = 0.0f;
        long xp = storedXP;
        while (xp > 0L) {
            long xpToNextLevel = ExperienceUtils.xpBarCap((int)storedLevels);
            if (xp < xpToNextLevel) {
                storedLevels += (float)xp / (float)xpToNextLevel;
                break;
            }
            xp -= xpToNextLevel;
            storedLevels += 1.0f;
        }
        return storedLevels;
    }

    public static long getXPToNextLevel(int currentXP) {
        long level = ExperienceUtils.getLevelForExperience(currentXP);
        long nextLevelXP = (int)ExperienceUtils.getExperienceForLevel(level + 1L);
        return nextLevelXP - (long)currentXP;
    }
}

