/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.events;

import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.blocks.PipeBlock;
import de.maxhenkel.pipez.items.FilterDestinationToolItem;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockEvents {
    @SubscribeEvent
    public void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        this.onDestinationToolClick(event);
        this.onPipeClick(event);
    }

    private void onPipeClick(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getLevel().m_8055_(event.getPos());
        if (!(state.m_60734_() instanceof PipeBlock)) {
            return;
        }
        PipeBlock pipe = (PipeBlock)state.m_60734_();
        Direction side = pipe.getSelection(state, (BlockGetter)event.getLevel(), event.getPos(), event.getEntity()).getKey();
        InteractionResult result = pipe.onPipeSideForceActivated(state, event.getLevel(), event.getPos(), event.getEntity(), event.getHand(), event.getHitVec(), side);
        if (result.m_19077_()) {
            event.setUseItem(Event.Result.ALLOW);
            event.setCancellationResult(result);
            event.setCanceled(true);
        }
    }

    private void onDestinationToolClick(PlayerInteractEvent.RightClickBlock event) {
        ItemStack heldItem = event.getEntity().m_21120_(event.getHand());
        if (!(heldItem.m_41720_() instanceof FilterDestinationToolItem)) {
            return;
        }
        BlockEntity te = event.getLevel().m_7702_(event.getPos());
        if (te == null) {
            return;
        }
        BlockState blockState = event.getLevel().m_8055_(event.getPos());
        if (blockState.m_60734_() instanceof PipeBlock) {
            return;
        }
        FilterDestinationToolItem.setDestination(heldItem, new DirectionalPosition(event.getPos().m_7949_(), event.getFace()));
        event.getEntity().m_5661_((Component)Component.m_237115_((String)"message.pipez.filter_destination_tool.destination.set"), true);
        event.setUseItem(Event.Result.ALLOW);
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }
}

