/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez;

import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.corelib.tag.Tag;
import de.maxhenkel.pipez.utils.GasTag;
import de.maxhenkel.pipez.utils.GasUtils;
import java.util.UUID;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class GasFilter
extends Filter<Chemical> {
    private ChemicalType type = ChemicalType.GAS;

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        if (this.tag != null) {
            if (this.tag instanceof SingleElementTag) {
                Chemical element = (Chemical)((SingleElementTag)this.tag).getElement();
                ChemicalType type = element == null ? ChemicalType.GAS : ChemicalType.getTypeFor((Chemical)element);
                ResourceLocation key = GasUtils.getResourceLocation(element);
                if (key != null) {
                    compound.m_128359_("Gas", key.toString());
                    compound.m_128359_("Type", type.m_7912_());
                }
            } else {
                compound.m_128359_("Tag", this.tag.getName().toString());
                compound.m_128359_("Type", this.type.m_7912_());
            }
        }
        if (this.destination != null) {
            compound.m_128365_("Destination", (net.minecraft.nbt.Tag)this.destination.serializeNBT());
        }
        if (this.invert) {
            compound.m_128379_("Invert", true);
        }
        compound.m_128362_("ID", this.id);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        this.tag = null;
        ChemicalType chemicalType = this.type = compound.m_128425_("Type", 8) ? ChemicalType.fromString((String)compound.m_128461_("Type")) : ChemicalType.GAS;
        if (compound.m_128425_("Gas", 8)) {
            ResourceLocation rl = new ResourceLocation(compound.m_128461_("Gas"));
            Chemical gas = (Chemical)GasUtils.getRegistry(this.type).getValue(rl);
            if (gas != null) {
                this.tag = new SingleElementTag<Chemical>(rl, gas);
            }
        }
        if (compound.m_128425_("Tag", 8)) {
            this.tag = GasUtils.getGasTag(compound.m_128461_("Tag"), false, this.type);
        }
        this.metadata = null;
        this.exactMetadata = false;
        if (compound.m_128425_("Destination", 10)) {
            this.destination = new DirectionalPosition();
            this.destination.deserializeNBT(compound.m_128469_("Destination"));
        } else {
            this.destination = null;
        }
        this.invert = compound.m_128425_("Invert", 1) ? compound.m_128471_("Invert") : false;
        this.id = compound.m_128425_("ID", 11) ? compound.m_128342_("ID") : UUID.randomUUID();
    }

    @Override
    public void setTag(@Nullable Tag<Chemical> tag) {
        super.setTag(tag);
        if (tag instanceof SingleElementTag) {
            Chemical element = (Chemical)((SingleElementTag)tag).getElement();
            this.type = element == null ? ChemicalType.GAS : ChemicalType.getTypeFor((Chemical)element);
        } else if (tag instanceof GasTag) {
            this.type = ((GasTag)tag).getChemicalType();
        }
    }

    public void setChemicalType(ChemicalType type) {
        this.type = type;
    }
}

