/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.Optional;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.utils.LazyTagLookup;
import moze_intel.projecte.utils.RegistryUtils;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.jetbrains.annotations.Nullable;

public class EntityRandomizerHelper {
    @Nullable
    public static Mob getRandomEntity(Level level, Mob toRandomize) {
        Rabbit rabbit;
        EntityType entType = toRandomize.m_6095_();
        boolean isPeaceful = entType.m_204039_(PETags.Entities.RANDOMIZER_PEACEFUL);
        boolean isHostile = entType.m_204039_(PETags.Entities.RANDOMIZER_HOSTILE);
        if (isPeaceful && isHostile && toRandomize instanceof Rabbit && (rabbit = (Rabbit)toRandomize).m_28554_() == Rabbit.Variant.EVIL) {
            isPeaceful = false;
        }
        if (isPeaceful) {
            return EntityRandomizerHelper.createRandomEntity(level, (Entity)toRandomize, PETags.Entities.RANDOMIZER_PEACEFUL);
        }
        if (isHostile) {
            Mob ent = EntityRandomizerHelper.createRandomEntity(level, (Entity)toRandomize, PETags.Entities.RANDOMIZER_HOSTILE);
            if (ent instanceof Rabbit) {
                Rabbit rabbit2 = (Rabbit)ent;
                rabbit2.m_28464_(Rabbit.Variant.EVIL);
            }
            return ent;
        }
        return null;
    }

    @Nullable
    private static Mob createRandomEntity(Level level, Entity current, TagKey<EntityType<?>> type) {
        EntityType newType;
        ITag tag = LazyTagLookup.tagManager(ForgeRegistries.ENTITY_TYPES).getTag(type);
        EntityType currentType = current.m_6095_();
        if (currentType == (newType = EntityRandomizerHelper.getRandomTagEntry(level.m_213780_(), tag, currentType))) {
            return null;
        }
        Entity newEntity = newType.m_20615_(level);
        if (newEntity instanceof Mob) {
            return (Mob)newEntity;
        }
        if (newEntity != null) {
            newEntity.m_146870_();
            PECore.LOGGER.warn("Invalid Entity type {} in mob randomizer tag {}. All entities in this tag are expected to be a mob.", (Object)RegistryUtils.getName(newType), (Object)type.f_203868_());
        }
        return null;
    }

    private static <T> T getRandomTagEntry(RandomSource random, ITag<T> tag, T toExclude) {
        Optional obj;
        int size = tag.size();
        if (size == 0 || size == 1 && tag.contains(toExclude)) {
            return toExclude;
        }
        while ((obj = tag.getRandomElement(random)).isPresent() && obj.get().equals(toExclude)) {
        }
        return obj.orElse(toExclude);
    }
}

