/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.block_entity.IDMPedestal;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.capability.PedestalItemCapabilityWrapper;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityHomingArrow;
import moze_intel.projecte.gameObjs.items.rings.PEToggleItem;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.to_server.LeftClickArchangelPKT;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class ArchangelSmite
extends PEToggleItem
implements IPedestalItem {
    public ArchangelSmite(Item.Properties props) {
        super(props);
        MinecraftForge.EVENT_BUS.addListener(this::emptyLeftClick);
        MinecraftForge.EVENT_BUS.addListener(this::leftClickBlock);
        this.addItemCapability(PedestalItemCapabilityWrapper::new);
    }

    public void fireVolley(ItemStack stack, Player player) {
        for (int i = 0; i < 10; ++i) {
            this.fireArrow(stack, player.m_9236_(), (LivingEntity)player, 4.0f);
        }
    }

    private void emptyLeftClick(PlayerInteractEvent.LeftClickEmpty evt) {
        PacketHandler.sendToServer(new LeftClickArchangelPKT());
    }

    private void leftClickBlock(PlayerInteractEvent.LeftClickBlock evt) {
        if (!evt.getLevel().f_46443_ && evt.getUseItem() != Event.Result.DENY && !evt.getItemStack().m_41619_() && evt.getItemStack().m_41720_() == this) {
            this.fireVolley(evt.getItemStack(), evt.getEntity());
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!player.m_9236_().f_46443_) {
            this.fireVolley(stack, player);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public void m_6883_(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int invSlot, boolean isSelected) {
        if (!level.f_46443_ && this.getMode(stack) == 1 && entity instanceof LivingEntity) {
            this.fireArrow(stack, level, (LivingEntity)entity, 1.0f);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        if (!level.f_46443_) {
            this.fireArrow(player.m_21120_(hand), level, (LivingEntity)player, 1.0f);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    private void fireArrow(ItemStack ring, Level level, LivingEntity shooter, float inaccuracy) {
        Player player;
        EntityHomingArrow arrow = new EntityHomingArrow(level, shooter, 2.0f);
        if (!(shooter instanceof Player) || ArchangelSmite.consumeFuel(player = (Player)shooter, ring, EMCHelper.getEmcValue((ItemLike)Items.f_42412_), true)) {
            arrow.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, 3.0f, inaccuracy);
            level.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (level.f_46441_.m_188501_() * 0.4f + 1.2f));
            level.m_7967_((Entity)arrow);
        }
    }

    @Override
    public <PEDESTAL extends BlockEntity> boolean updateInPedestal(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockPos pos, @NotNull PEDESTAL pedestal) {
        if (!level.f_46443_ && ProjectEConfig.server.cooldown.pedestal.archangel.get() != -1) {
            if (((IDMPedestal)pedestal).getActivityCooldown() == 0) {
                if (!level.m_45976_(Mob.class, ((IDMPedestal)pedestal).getEffectBounds()).isEmpty()) {
                    double centeredX = (double)pos.m_123341_() + 0.5;
                    double centeredY = (double)pos.m_123342_() + 0.5;
                    double centeredZ = (double)pos.m_123343_() + 0.5;
                    for (int i = 0; i < 3; ++i) {
                        EntityHomingArrow arrow = new EntityHomingArrow(level, (LivingEntity)FakePlayerFactory.get((ServerLevel)((ServerLevel)level), (GameProfile)PECore.FAKEPLAYER_GAMEPROFILE), 2.0f);
                        arrow.m_20343_(centeredX, centeredY + 2.0, centeredZ);
                        arrow.m_20334_(0.0, 1.0, 0.0);
                        arrow.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (level.f_46441_.m_188501_() * 0.4f + 1.2f) + 0.5f);
                        level.m_7967_((Entity)arrow);
                    }
                }
                ((IDMPedestal)pedestal).setActivityCooldown(ProjectEConfig.server.cooldown.pedestal.archangel.get());
            } else {
                ((IDMPedestal)pedestal).decrementActivityCooldown();
            }
        }
        return false;
    }

    @Override
    @NotNull
    public List<Component> getPedestalDescription() {
        ArrayList<Component> list = new ArrayList<Component>();
        if (ProjectEConfig.server.cooldown.pedestal.archangel.get() != -1) {
            list.add((Component)PELang.PEDESTAL_ARCHANGEL_1.translateColored(ChatFormatting.BLUE, new Object[0]));
            list.add((Component)PELang.PEDESTAL_ARCHANGEL_2.translateColored(ChatFormatting.BLUE, MathUtils.tickToSecFormatted(ProjectEConfig.server.cooldown.pedestal.archangel.get())));
        }
        return list;
    }
}

