/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import moze_intel.projecte.gameObjs.items.IFlightProvider;
import moze_intel.projecte.gameObjs.items.IStepAssister;
import moze_intel.projecte.gameObjs.items.armor.GemArmorBase;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GemFeet
extends GemArmorBase
implements IFlightProvider,
IStepAssister {
    private static final UUID MODIFIER = UUID.fromString("A4334312-DFF8-4582-9F4F-62AD0C070475");
    private final Multimap<Attribute, AttributeModifier> attributes;

    public GemFeet(Item.Properties props) {
        super(ArmorItem.Type.BOOTS, props);
        ImmutableMultimap.Builder attributesBuilder = ImmutableMultimap.builder();
        attributesBuilder.putAll(this.m_7167_(EquipmentSlot.FEET));
        attributesBuilder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(MODIFIER, "Armor modifier", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        this.attributes = attributesBuilder.build();
    }

    public void toggleStepAssist(ItemStack boots, Player player) {
        boolean value;
        CompoundTag bootsTag = boots.m_41784_();
        if (bootsTag.m_128425_("StepAssist", 1)) {
            value = !bootsTag.m_128471_("StepAssist");
            bootsTag.m_128379_("StepAssist", value);
        } else {
            bootsTag.m_128379_("StepAssist", true);
            value = true;
        }
        if (value) {
            player.m_213846_((Component)PELang.STEP_ASSIST.translate(ChatFormatting.GREEN, PELang.GEM_ENABLED));
        } else {
            player.m_213846_((Component)PELang.STEP_ASSIST.translate(ChatFormatting.RED, PELang.GEM_DISABLED));
        }
    }

    private static boolean isJumpPressed() {
        return (Boolean)DistExecutor.unsafeRunForDist(() -> () -> Minecraft.m_91087_().f_91066_.f_92089_.m_90857_(), () -> () -> false);
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (!level.f_46443_) {
            ServerPlayer playerMP = (ServerPlayer)player;
            playerMP.f_19789_ = 0.0f;
        } else {
            if (!player.m_150110_().f_35935_ && GemFeet.isJumpPressed()) {
                player.m_20256_(player.m_20184_().m_82520_(0.0, 0.1, 0.0));
            }
            if (!player.m_20096_()) {
                if (player.m_20184_().m_7098_() <= 0.0) {
                    player.m_20256_(player.m_20184_().m_82542_(1.0, 0.9, 1.0));
                }
                if (!player.m_150110_().f_35935_) {
                    if (player.f_20902_ < 0.0f) {
                        player.m_20256_(player.m_20184_().m_82542_(0.9, 1.0, 0.9));
                    } else if (player.f_20902_ > 0.0f && player.m_20184_().m_82556_() < 3.0) {
                        player.m_20256_(player.m_20184_().m_82542_(1.1, 1.0, 1.1));
                    }
                }
            }
        }
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltips, @NotNull TooltipFlag flags) {
        super.m_7373_(stack, level, tooltips, flags);
        tooltips.add((Component)PELang.GEM_LORE_FEET.translate(new Object[0]));
        tooltips.add((Component)PELang.STEP_ASSIST_PROMPT.translate(ClientKeyHelper.getKeyName(PEKeybind.BOOTS_TOGGLE)));
        if (ItemHelper.checkItemNBT(stack, "StepAssist")) {
            tooltips.add((Component)PELang.STEP_ASSIST.translate(ChatFormatting.GREEN, PELang.GEM_ENABLED));
        } else {
            tooltips.add((Component)PELang.STEP_ASSIST.translate(ChatFormatting.RED, PELang.GEM_DISABLED));
        }
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@NotNull EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.FEET ? this.attributes : super.getAttributeModifiers(slot, stack);
    }

    @Override
    public boolean canProvideFlight(ItemStack stack, ServerPlayer player) {
        return player.m_6844_(EquipmentSlot.FEET) == stack;
    }

    @Override
    public boolean canAssistStep(ItemStack stack, ServerPlayer player) {
        return player.m_6844_(EquipmentSlot.FEET) == stack && ItemHelper.checkItemNBT(stack, "StepAssist");
    }
}

