/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.data;

import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import moze_intel.projecte.api.data.CustomConversionBuilder;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class CustomConversionProvider
implements DataProvider {
    private final Map<ResourceLocation, CustomConversionBuilder> customConversions = new LinkedHashMap<ResourceLocation, CustomConversionBuilder>();
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final Path outputFolder;

    protected CustomConversionProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        this.outputFolder = output.m_247566_(PackOutput.Target.DATA_PACK);
        this.lookupProvider = lookupProvider;
    }

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        return ((CompletableFuture)this.lookupProvider.thenApply(registries -> {
            this.customConversions.clear();
            this.addCustomConversions((HolderLookup.Provider)registries);
            return registries;
        })).thenCompose(registries -> {
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            for (Map.Entry<ResourceLocation, CustomConversionBuilder> entry : this.customConversions.entrySet()) {
                ResourceLocation customConversion = entry.getKey();
                Path path = this.outputFolder.resolve(customConversion.m_135827_() + "/pe_custom_conversions/" + customConversion.m_135815_() + ".json");
                futures.add(DataProvider.m_253162_((CachedOutput)output, (JsonElement)entry.getValue().serialize(), (Path)path));
            }
            return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
        });
    }

    protected abstract void addCustomConversions(HolderLookup.Provider var1);

    protected CustomConversionBuilder createConversionBuilder(ResourceLocation id) {
        Objects.requireNonNull(id, "Custom Conversion Builder ID cannot be null.");
        if (this.customConversions.containsKey(id)) {
            throw new RuntimeException("Custom conversion '" + id + "' has already been registered.");
        }
        CustomConversionBuilder conversionBuilder = new CustomConversionBuilder(id);
        this.customConversions.put(id, conversionBuilder);
        return conversionBuilder;
    }

    public String m_6055_() {
        return "Custom EMC Conversions";
    }
}

