/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.events.PermissionGatherEvent;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionType;
import net.minecraftforge.server.permission.nodes.PermissionTypes;
import org.jetbrains.annotations.Nullable;

public class PEPermissions {
    private static final List<PermissionNode<?>> NODES_TO_REGISTER = new ArrayList();
    private static final PermissionNode.PermissionResolver<Boolean> PLAYER_IS_OP = (player, uuid, context) -> player != null && player.m_20310_(2);
    private static final PermissionNode.PermissionResolver<Boolean> ALWAYS_TRUE = (player, uuid, context) -> true;
    public static final CommandPermissionNode COMMAND = new CommandPermissionNode(PEPermissions.node("command", PermissionTypes.BOOLEAN, (player, uuid, contexts) -> player != null && player.m_20310_(0), new PermissionDynamicContextKey[0]), 0);
    public static final CommandPermissionNode COMMAND_REMOVE_EMC = PEPermissions.nodeOpCommand("remove_emc");
    public static final CommandPermissionNode COMMAND_RESET_EMC = PEPermissions.nodeOpCommand("reset_emc");
    public static final CommandPermissionNode COMMAND_SET_EMC = PEPermissions.nodeOpCommand("set_emc");
    public static final CommandPermissionNode COMMAND_SHOW_BAG = PEPermissions.nodeOpCommand("show_bag");
    public static final CommandPermissionNode COMMAND_EMC = PEPermissions.nodeOpCommand("emc");
    public static final CommandPermissionNode COMMAND_EMC_ADD = PEPermissions.nodeSubCommand(COMMAND_EMC, "add");
    public static final CommandPermissionNode COMMAND_EMC_REMOVE = PEPermissions.nodeSubCommand(COMMAND_EMC, "remove");
    public static final CommandPermissionNode COMMAND_EMC_SET = PEPermissions.nodeSubCommand(COMMAND_EMC, "set");
    public static final CommandPermissionNode COMMAND_EMC_TEST = PEPermissions.nodeSubCommand(COMMAND_EMC, "test");
    public static final CommandPermissionNode COMMAND_EMC_GET = PEPermissions.nodeSubCommand(COMMAND_EMC, "get");
    public static final CommandPermissionNode COMMAND_KNOWLEDGE = PEPermissions.nodeOpCommand("knowledge");
    public static final CommandPermissionNode COMMAND_KNOWLEDGE_CLEAR = PEPermissions.nodeSubCommand(COMMAND_KNOWLEDGE, "clear");
    public static final CommandPermissionNode COMMAND_KNOWLEDGE_LEARN = PEPermissions.nodeSubCommand(COMMAND_KNOWLEDGE, "learn");
    public static final CommandPermissionNode COMMAND_KNOWLEDGE_UNLEARN = PEPermissions.nodeSubCommand(COMMAND_KNOWLEDGE, "unlearn");
    public static final CommandPermissionNode COMMAND_KNOWLEDGE_TEST = PEPermissions.nodeSubCommand(COMMAND_KNOWLEDGE, "test");

    private static CommandPermissionNode nodeOpCommand(String nodeName) {
        PermissionNode<Boolean> node = PEPermissions.node("command." + nodeName, PermissionTypes.BOOLEAN, PLAYER_IS_OP, new PermissionDynamicContextKey[0]);
        return new CommandPermissionNode(node, 2);
    }

    private static CommandPermissionNode nodeSubCommand(CommandPermissionNode parent, String nodeName) {
        PermissionNode<Boolean> node = PEPermissions.subNode(parent.node, nodeName, ALWAYS_TRUE);
        return new CommandPermissionNode(node, parent.fallbackLevel);
    }

    private static <T> PermissionNode<T> subNode(PermissionNode<T> parent, String nodeName) {
        return PEPermissions.subNode(parent, nodeName, (player, uuid, context) -> PEPermissions.getPermission(player, uuid, parent, context));
    }

    private static <T> PermissionNode<T> subNode(PermissionNode<T> parent, String nodeName, ResultTransformer<T> defaultRestrictionIncrease) {
        return PEPermissions.subNode(parent, nodeName, (player, uuid, context) -> {
            Object result = PEPermissions.getPermission(player, uuid, parent, context);
            return defaultRestrictionIncrease.transform(player, uuid, result, context);
        });
    }

    private static <T> PermissionNode<T> subNode(PermissionNode<T> parent, String nodeName, PermissionNode.PermissionResolver<T> defaultResolver) {
        String fullParentName = parent.getNodeName();
        String parentName = fullParentName.substring(fullParentName.indexOf(46) + 1);
        return PEPermissions.node(parentName + "." + nodeName, parent.getType(), defaultResolver, new PermissionDynamicContextKey[0]);
    }

    @SafeVarargs
    private static <T> PermissionNode<T> node(String nodeName, PermissionType<T> type, PermissionNode.PermissionResolver<T> defaultResolver, PermissionDynamicContextKey<T> ... dynamics) {
        PermissionNode node = new PermissionNode("projecte", nodeName, type, defaultResolver, dynamics);
        NODES_TO_REGISTER.add(node);
        return node;
    }

    public static void registerPermissionNodes(PermissionGatherEvent.Nodes event) {
        event.addNodes(NODES_TO_REGISTER);
    }

    private static <T> T getPermission(@Nullable ServerPlayer player, UUID playerUUID, PermissionNode<T> node, PermissionDynamicContext<?> ... context) {
        if (player == null) {
            return (T)PermissionAPI.getOfflinePermission((UUID)playerUUID, node, context);
        }
        return (T)PermissionAPI.getPermission((ServerPlayer)player, node, context);
    }

    public record CommandPermissionNode(PermissionNode<Boolean> node, int fallbackLevel) implements Predicate<CommandSourceStack>
    {
        @Override
        public boolean test(CommandSourceStack source) {
            ServerPlayer player;
            CommandSource commandSource;
            return source.m_6761_(this.fallbackLevel) || (commandSource = source.f_81288_) instanceof ServerPlayer && (Boolean)PermissionAPI.getPermission((ServerPlayer)(player = (ServerPlayer)commandSource), this.node, (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false;
        }
    }

    @FunctionalInterface
    private static interface ResultTransformer<T> {
        public T transform(@Nullable ServerPlayer var1, UUID var2, T var3, PermissionDynamicContext<?> ... var4);
    }
}

