/*
 * Decompiled with CFR 0.152.
 */
package cn.leomc.teamprojecte;

import cn.leomc.teamprojecte.TPTeam;
import cn.leomc.teamprojecte.TeamProjectE;
import com.google.common.base.Suppliers;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.event.PlayerKnowledgeChangeEvent;
import moze_intel.projecte.emc.EMCMappingHandler;
import moze_intel.projecte.emc.nbt.NBTManager;
import moze_intel.projecte.gameObjs.items.Tome;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.IPEPacket;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncChangePKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncEmcPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncInputsAndLocksPKT;
import moze_intel.projecte.network.packets.to_client.knowledge.KnowledgeSyncPKT;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamKnowledgeProvider
implements IKnowledgeProvider {
    private final Supplier<UUID> playerUUID;
    private final ItemStackHandler inputLocks = new ItemStackHandler(9);

    public TeamKnowledgeProvider(@NotNull ServerPlayer player) {
        this.playerUUID = Suppliers.memoize(() -> TeamProjectE.getPlayerUUID((Player)player));
    }

    public TeamKnowledgeProvider(UUID uuid) {
        this.playerUUID = () -> uuid;
    }

    private void fireChangedEvent() {
        this.getTeam().getAll().forEach(uuid -> MinecraftForge.EVENT_BUS.post((Event)new PlayerKnowledgeChangeEvent(uuid)));
    }

    private TPTeam getTeam() {
        return TPTeam.getOrCreateTeam(this.playerUUID.get());
    }

    public boolean hasFullKnowledge() {
        return this.getTeam().hasFullKnowledge(this.playerUUID.get());
    }

    public void setFullKnowledge(boolean fullKnowledge) {
        boolean changed = this.hasFullKnowledge() != fullKnowledge;
        this.getTeam().setFullKnowledge(fullKnowledge, this.playerUUID.get());
        if (changed) {
            this.fireChangedEvent();
        }
    }

    public void clearKnowledge() {
        boolean hasKnowledge = this.hasFullKnowledge() || !this.getTeam().getKnowledge(this.playerUUID.get()).isEmpty();
        this.getTeam().clearKnowledge(this.playerUUID.get());
        this.getTeam().setFullKnowledge(false, this.playerUUID.get());
        if (hasKnowledge) {
            this.fireChangedEvent();
        }
    }

    @Nullable
    private ItemInfo getIfPersistent(@NotNull ItemInfo info) {
        if (!info.hasNBT() || EMCMappingHandler.hasEmcValue((ItemInfo)info)) {
            return null;
        }
        ItemInfo cleanedInfo = NBTManager.getPersistentInfo((ItemInfo)info);
        if (cleanedInfo.hasNBT() && !EMCMappingHandler.hasEmcValue((ItemInfo)cleanedInfo)) {
            return cleanedInfo;
        }
        return null;
    }

    public boolean hasKnowledge(@NotNull ItemInfo info) {
        if (this.getTeam().hasFullKnowledge(this.playerUUID.get())) {
            ItemInfo persistentInfo = this.getIfPersistent(info);
            return persistentInfo == null || this.getTeam().getKnowledge(this.playerUUID.get()).contains(persistentInfo);
        }
        return this.getTeam().getKnowledge(this.playerUUID.get()).contains(NBTManager.getPersistentInfo((ItemInfo)info));
    }

    public boolean addKnowledge(@NotNull ItemInfo info) {
        if (this.getTeam().hasFullKnowledge(this.playerUUID.get())) {
            ItemInfo persistentInfo = this.getIfPersistent(info);
            if (persistentInfo == null) {
                return false;
            }
            return this.tryAdd(persistentInfo);
        }
        if (info.getItem() instanceof Tome) {
            if (info.hasNBT()) {
                info = ItemInfo.fromItem((ItemLike)info.getItem());
            }
            this.getTeam().addKnowledge(info, this.playerUUID.get());
            this.getTeam().setFullKnowledge(true, this.playerUUID.get());
            this.fireChangedEvent();
            return true;
        }
        return this.tryAdd(NBTManager.getPersistentInfo((ItemInfo)info));
    }

    private boolean tryAdd(@NotNull ItemInfo cleanedInfo) {
        if (this.getTeam().addKnowledge(cleanedInfo, this.playerUUID.get())) {
            this.fireChangedEvent();
            return true;
        }
        return false;
    }

    public boolean removeKnowledge(@NotNull ItemInfo info) {
        if (this.getTeam().hasFullKnowledge(this.playerUUID.get())) {
            if (info.getItem() instanceof Tome) {
                if (info.hasNBT()) {
                    info = ItemInfo.fromItem((ItemLike)info.getItem());
                }
                this.getTeam().removeKnowledge(info, this.playerUUID.get());
                this.getTeam().setFullKnowledge(false, this.playerUUID.get());
                this.fireChangedEvent();
                return true;
            }
            ItemInfo persistentInfo = this.getIfPersistent(info);
            return persistentInfo != null && this.tryRemove(persistentInfo);
        }
        return this.tryRemove(NBTManager.getPersistentInfo((ItemInfo)info));
    }

    private boolean tryRemove(@NotNull ItemInfo cleanedInfo) {
        if (this.getTeam().removeKnowledge(cleanedInfo, this.playerUUID.get())) {
            this.fireChangedEvent();
            return true;
        }
        return false;
    }

    @NotNull
    public Set<ItemInfo> getKnowledge() {
        if (this.getTeam().hasFullKnowledge(this.playerUUID.get())) {
            Set allKnowledge = EMCMappingHandler.getMappedItems();
            allKnowledge.addAll(this.getTeam().getKnowledge(this.playerUUID.get()));
            return Collections.unmodifiableSet(allKnowledge);
        }
        return Collections.unmodifiableSet(this.getTeam().getKnowledge(this.playerUUID.get()));
    }

    @NotNull
    public IItemHandlerModifiable getInputAndLocks() {
        return this.inputLocks;
    }

    public BigInteger getEmc() {
        return this.getTeam().getEmc(this.playerUUID.get());
    }

    public void setEmc(BigInteger emc) {
        this.getTeam().setEmc(emc, this.playerUUID.get());
    }

    public void sync(@NotNull ServerPlayer player) {
        if (!this.getTeam().isSharingEMC() && !this.getTeam().isSharingKnowledge()) {
            TeamKnowledgeProvider.sendKnowledgeSync(player);
        } else {
            TeamProjectE.getOnlineTeamMembers(TeamProjectE.getPlayerUUID((Player)player)).forEach(TeamKnowledgeProvider::sendKnowledgeSync);
        }
    }

    private static void sendKnowledgeSync(ServerPlayer player) {
        player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY).ifPresent(cap -> PacketHandler.sendTo((IPEPacket)new KnowledgeSyncPKT(((TeamKnowledgeProvider)cap).serializeForClient()), (ServerPlayer)player));
    }

    private CompoundTag serializeForClient() {
        CompoundTag properties = new CompoundTag();
        properties.m_128359_("transmutationEmc", this.getTeam().getEmc(this.playerUUID.get()).toString());
        ListTag knowledgeWrite = new ListTag();
        for (ItemInfo i : this.getTeam().getKnowledge(this.playerUUID.get())) {
            knowledgeWrite.add((Object)i.write(new CompoundTag()));
        }
        properties.m_128365_("knowledge", (Tag)knowledgeWrite);
        properties.m_128365_("inputlock", (Tag)this.inputLocks.serializeNBT());
        properties.m_128379_("fullknowledge", this.getTeam().hasFullKnowledge(this.playerUUID.get()));
        return properties;
    }

    public void syncEmc(@NotNull ServerPlayer player) {
        TeamKnowledgeProvider.sendPacket((IPEPacket)new KnowledgeSyncEmcPKT(this.getEmc()), player, this.getTeam().isSharingEMC());
    }

    public void syncKnowledgeChange(@NotNull ServerPlayer player, ItemInfo change, boolean learned) {
        TeamKnowledgeProvider.sendPacket((IPEPacket)new KnowledgeSyncChangePKT(change, learned), player, this.getTeam().isSharingKnowledge());
    }

    private static void sendPacket(IPEPacket packet, ServerPlayer player, boolean team) {
        if (team) {
            TeamProjectE.getOnlineTeamMembers(TeamProjectE.getPlayerUUID((Player)player)).forEach(p -> PacketHandler.sendTo((IPEPacket)packet, (ServerPlayer)p));
        } else {
            PacketHandler.sendTo((IPEPacket)packet, (ServerPlayer)player);
        }
    }

    public void syncInputAndLocks(@NotNull ServerPlayer player, List<Integer> slotsChanged, IKnowledgeProvider.TargetUpdateType updateTargets) {
        if (!slotsChanged.isEmpty()) {
            int slots = this.inputLocks.getSlots();
            HashMap<Integer, ItemStack> stacksToSync = new HashMap<Integer, ItemStack>();
            for (int slot : slotsChanged) {
                if (slot < 0 || slot >= slots) continue;
                stacksToSync.put(slot, this.inputLocks.getStackInSlot(slot));
            }
            if (!stacksToSync.isEmpty()) {
                PacketHandler.sendTo((IPEPacket)new KnowledgeSyncInputsAndLocksPKT(stacksToSync, updateTargets), (ServerPlayer)player);
            }
        }
    }

    public void receiveInputsAndLocks(Map<Integer, ItemStack> changes) {
        int slots = this.inputLocks.getSlots();
        for (Map.Entry<Integer, ItemStack> entry : changes.entrySet()) {
            int slot = entry.getKey();
            if (slot < 0 || slot >= slots) continue;
            this.inputLocks.setStackInSlot(slot, entry.getValue());
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag properties = new CompoundTag();
        properties.m_128365_("inputlock", (Tag)this.inputLocks.serializeNBT());
        return properties;
    }

    public void deserializeNBT(CompoundTag properties) {
        for (int i = 0; i < this.inputLocks.getSlots(); ++i) {
            this.inputLocks.setStackInSlot(i, ItemStack.f_41583_);
        }
        this.inputLocks.deserializeNBT(properties.m_128469_("inputlock"));
    }
}

