/*
 * Decompiled with CFR 0.152.
 */
package cn.leomc.teamprojecte;

import cn.leomc.teamprojecte.TPTeam;
import cn.leomc.teamprojecte.TeamChangeEvent;
import cn.leomc.teamprojecte.TeamProjectE;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;

public class TPCommand {
    public static final Multimap<UUID, UUID> INVITATIONS = HashMultimap.create();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"team_projecte").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"invite").requires(TPCommand::requiresPlayer)).then(Commands.m_82129_((String)"players", (ArgumentType)EntityArgument.m_91470_()).executes(TPCommand::invite)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"leave").requires(TPCommand::requiresInTeam)).executes(TPCommand::leave))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"transfer_ownership").requires(TPCommand::requiresOwner)).then(Commands.m_82129_((String)"member", (ArgumentType)EntityArgument.m_91466_()).executes(TPCommand::transferOwnership)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"members").requires(TPCommand::requiresInTeam)).executes(TPCommand::members))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"kick").requires(TPCommand::requiresOwner)).then(Commands.m_82129_((String)"members", (ArgumentType)EntityArgument.m_91470_()).executes(TPCommand::kick)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"accept").requires(TPCommand::requiresPlayer)).then(Commands.m_82129_((String)"team", (ArgumentType)UuidArgument.m_113850_()).suggests(TPCommand::createSuggestionsForInvitation).executes(TPCommand::accept)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"decline").requires(TPCommand::requiresPlayer)).then(Commands.m_82129_((String)"team", (ArgumentType)UuidArgument.m_113850_()).suggests(TPCommand::createSuggestionsForInvitation).executes(TPCommand::decline)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"settings").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"share_emc").executes(TPCommand::queryShareEMC)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).requires(TPCommand::requiresOwner)).executes(TPCommand::setShareEMC)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"share_knowledge").executes(TPCommand::queryShareKnowledge)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"value", (ArgumentType)BoolArgumentType.bool()).requires(TPCommand::requiresOwner)).executes(TPCommand::setShareKnowledge)))));
    }

    private static boolean requiresPlayer(CommandSourceStack stack) {
        return stack.m_81373_() instanceof ServerPlayer;
    }

    private static boolean requiresInTeam(CommandSourceStack stack) {
        Entity entity = stack.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            TPTeam team = TPTeam.getTeamByMember(TeamProjectE.getPlayerUUID((Player)player));
            return team != null && (!team.getOwner().equals(TeamProjectE.getPlayerUUID((Player)player)) || !team.getMembers().isEmpty());
        }
        return false;
    }

    private static boolean requiresOwner(CommandSourceStack stack) {
        if (!TPCommand.requiresInTeam(stack)) {
            return false;
        }
        Entity entity = stack.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            TPTeam team = TPTeam.getTeamByMember(TeamProjectE.getPlayerUUID((Player)player));
            return team != null && TeamProjectE.getPlayerUUID((Player)player).equals(team.getOwner());
        }
        return false;
    }

    private static int transferOwnership(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = TPCommand.checkPlayer(context);
        TPTeam team = TPCommand.checkInTeam((Player)player);
        if (team == null || !TPCommand.checkOwner(team, player)) {
            return 0;
        }
        ServerPlayer newOwner = EntityArgument.m_91474_(context, (String)"member");
        UUID newOwnerUUID = TeamProjectE.getPlayerUUID((Player)newOwner);
        if (!team.getAll().contains(newOwnerUUID)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.teamprojecte.transfer_ownership.not_in_team"));
            return 0;
        }
        if (team.getOwner().equals(newOwnerUUID)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.teamprojecte.transfer_ownership.already_owner"));
            return 0;
        }
        team.transferOwner(newOwnerUUID);
        newOwner.m_213846_((Component)Component.m_237115_((String)"commands.teamprojecte.transfer_ownership.new_owner").m_130940_(ChatFormatting.GREEN));
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.teamprojecte.transfer_ownership.success", (Object[])new Object[]{newOwner.m_7755_()}), true);
        TPCommand.postTeamAttributeChangeEvent(team);
        return 1;
    }

    private static int kick(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = TPCommand.checkPlayer(context);
        TPTeam team = TPCommand.checkInTeam((Player)player);
        if (team == null || !TPCommand.checkOwner(team, player)) {
            return 0;
        }
        List<ServerPlayer> kick = EntityArgument.m_91477_(context, (String)"members").stream().filter(p -> team.getMembers().contains(TeamProjectE.getPlayerUUID((Player)p))).toList();
        kick.forEach(p -> {
            team.removeMember(TeamProjectE.getPlayerUUID((Player)p));
            p.m_213846_((Component)Component.m_237115_((String)"commands.teamprojecte.kicked").m_130940_(ChatFormatting.RED));
            UUID uuid = TeamProjectE.getPlayerUUID((Player)p);
            TPCommand.postTeamMemberChangeEvent(uuid, team, null);
        });
        if (!kick.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.teamprojecte.kick.success", (Object[])new Object[]{kick.size()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.teamprojecte.players_not_found"));
        }
        return kick.size();
    }

    private static int members(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = TPCommand.checkPlayer(context);
        TPTeam team = TPCommand.checkInTeam((Player)player);
        if (team == null) {
            return 0;
        }
        player.m_213846_((Component)Component.m_237110_((String)"commands.teamprojecte.members", (Object[])new Object[]{TPCommand.getNames(team.getOwner(), team.getAll())}));
        return 1;
    }

    private static Component getNames(UUID owner, List<UUID> uuids) {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        PlayerList playerList = ServerLifecycleHooks.getCurrentServer().m_6846_();
        for (UUID uuid : uuids) {
            ServerPlayer player = playerList.m_11259_(uuid);
            MutableComponent component = player != null ? player.m_7755_().m_6881_().m_130940_(ChatFormatting.GREEN).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"commands.teamprojecte.members.member_online")))) : (UsernameCache.containsUUID((UUID)uuid) ? Component.m_237113_((String)UsernameCache.getLastKnownUsername((UUID)uuid)).m_130940_(ChatFormatting.RED).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"commands.teamprojecte.members.member_offline")))) : Component.m_237113_((String)uuid.toString()).m_130940_(ChatFormatting.GRAY).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"commands.teamprojecte.members.member_unknown")))));
            if (uuid.equals(owner)) {
                component.m_130940_(ChatFormatting.BOLD);
            }
            components.add(component);
        }
        return ComponentUtils.m_178440_(components, c -> c);
    }

    private static int leave(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = TPCommand.checkPlayer(context);
        TPTeam team = TPCommand.checkInTeam((Player)player);
        if (team == null) {
            return 0;
        }
        UUID uuid = TeamProjectE.getPlayerUUID((Player)player);
        team.removeMember(uuid);
        TPCommand.postTeamMemberChangeEvent(uuid, team, null);
        return 1;
    }

    private static int accept(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = TPCommand.checkPlayer(context);
        UUID uuid = UuidArgument.m_113853_(context, (String)"team");
        if (!INVITATIONS.get((Object)TeamProjectE.getPlayerUUID((Player)player)).contains(uuid)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.teamprojecte.invitation.not_found"));
            return -1;
        }
        INVITATIONS.remove((Object)TeamProjectE.getPlayerUUID((Player)player), (Object)uuid);
        TPTeam team = TPTeam.getTeam(uuid);
        if (team == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.teamprojecte.team_not_found"));
            return -1;
        }
        TPTeam originalTeam = TPTeam.getTeamByMember(TeamProjectE.getPlayerUUID((Player)player));
        if (originalTeam != null) {
            team.addMemberWithKnowledge(originalTeam, (Player)player);
        } else {
            team.addMember(TeamProjectE.getPlayerUUID((Player)player));
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.teamprojecte.invite.accepted").m_130940_(ChatFormatting.GREEN), false);
        MutableComponent component = Component.m_237110_((String)"commands.teamprojecte.joined_team", (Object[])new Object[]{player.m_5446_()}).m_130940_(ChatFormatting.GREEN);
        TeamProjectE.getAllOnline(team.getAll()).forEach(arg_0 -> TPCommand.lambda$accept$9((Component)component, arg_0));
        TPCommand.postTeamMemberChangeEvent(uuid, originalTeam, team);
        return 1;
    }

    private static int decline(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = TPCommand.checkPlayer(context);
        UUID uuid = UuidArgument.m_113853_(context, (String)"team");
        if (!INVITATIONS.get((Object)TeamProjectE.getPlayerUUID((Player)player)).contains(uuid)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.teamprojecte.invitation.not_found"));
            return -1;
        }
        INVITATIONS.remove((Object)TeamProjectE.getPlayerUUID((Player)player), (Object)uuid);
        TPTeam team = TPTeam.getTeam(uuid);
        if (team == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.teamprojecte.team_not_found"));
            return -1;
        }
        player.m_213846_((Component)Component.m_237115_((String)"commands.teamprojecte.invite.declined").m_130940_(ChatFormatting.RED));
        TeamProjectE.getAllOnline(Collections.singletonList(team.getOwner())).forEach(p -> p.m_213846_((Component)Component.m_237110_((String)"commands.teamprojecte.invitation.declined", (Object[])new Object[]{player.m_5446_()})));
        return 1;
    }

    private static CompletableFuture<Suggestions> createSuggestionsForInvitation(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        ServerPlayer player = TPCommand.checkPlayer(context);
        return SharedSuggestionProvider.m_82981_(INVITATIONS.get((Object)TeamProjectE.getPlayerUUID((Player)player)).stream().map(UUID::toString), (SuggestionsBuilder)builder);
    }

    private static int invite(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = TPCommand.checkPlayer(context);
        TPTeam team = TPTeam.getOrCreateTeam(TeamProjectE.getPlayerUUID((Player)player));
        List<ServerPlayer> players = EntityArgument.m_91477_(context, (String)"players").stream().filter(p -> !team.getAll().contains(TeamProjectE.getPlayerUUID((Player)p))).toList();
        MutableComponent component = Component.m_237110_((String)"commands.teamprojecte.invitation", (Object[])new Object[]{player.m_5446_(), Component.m_237115_((String)"commands.teamprojecte.invite.option.accept").m_130938_(style -> style.m_131157_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/team_projecte accept " + team.getUUID()))), Component.m_237115_((String)"commands.teamprojecte.invite.option.decline").m_130938_(style -> style.m_131157_(ChatFormatting.RED).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/team_projecte decline " + team.getUUID())))});
        for (ServerPlayer p2 : players) {
            INVITATIONS.put((Object)TeamProjectE.getPlayerUUID((Player)p2), (Object)team.getUUID());
            p2.m_213846_((Component)component);
        }
        if (!players.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.teamprojecte.invite.success", (Object[])new Object[]{players.size()}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.teamprojecte.players_not_found"));
        }
        return players.size();
    }

    private static ServerPlayer checkPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return player;
        }
        throw CommandSourceStack.f_81286_.create();
    }

    private static TPTeam checkInTeam(Player player) {
        TPTeam team = TPTeam.getTeamByMember(TeamProjectE.getPlayerUUID(player));
        if (team == null || team.getOwner().equals(TeamProjectE.getPlayerUUID(player)) && team.getMembers().isEmpty()) {
            player.m_213846_((Component)Component.m_237115_((String)"commands.teamprojecte.leave.not_in_team").m_130940_(ChatFormatting.RED));
            return null;
        }
        return team;
    }

    private static boolean checkOwner(TPTeam team, ServerPlayer player) {
        if (!TeamProjectE.getPlayerUUID((Player)player).equals(team.getOwner())) {
            player.m_213846_((Component)Component.m_237115_((String)"commands.teamprojecte.not_owner").m_130940_(ChatFormatting.RED));
            return false;
        }
        return true;
    }

    private static int queryShareEMC(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = TPCommand.checkPlayer(context);
        TPTeam team = TPCommand.checkInTeam((Player)player);
        if (team == null) {
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("commands.teamprojecte.settings.query.sharing_emc." + team.isSharingEMC())), true);
        return 1;
    }

    private static int setShareEMC(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = TPCommand.checkPlayer(context);
        TPTeam team = TPCommand.checkInTeam((Player)player);
        if (team == null || !TPCommand.checkOwner(team, player)) {
            return 0;
        }
        team.setShareEMC(BoolArgumentType.getBool(context, (String)"value"));
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("commands.teamprojecte.settings.set.sharing_emc." + team.isSharingEMC())), true);
        TPCommand.postTeamAttributeChangeEvent(team);
        return 1;
    }

    private static int queryShareKnowledge(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = TPCommand.checkPlayer(context);
        TPTeam team = TPCommand.checkInTeam((Player)player);
        if (team == null) {
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("commands.teamprojecte.settings.query.sharing_knowledge." + team.isSharingKnowledge())), true);
        return 1;
    }

    private static int setShareKnowledge(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = TPCommand.checkPlayer(context);
        TPTeam team = TPCommand.checkInTeam((Player)player);
        if (team == null || !TPCommand.checkOwner(team, player)) {
            return 0;
        }
        team.setShareKnowledge(BoolArgumentType.getBool(context, (String)"value"));
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)("commands.teamprojecte.settings.set.sharing_knowledge." + team.isSharingKnowledge())), true);
        TPCommand.postTeamAttributeChangeEvent(team);
        return 1;
    }

    private static void postTeamMemberChangeEvent(UUID playerUUID, TPTeam oldTeam, TPTeam newTeam) {
        MinecraftForge.EVENT_BUS.post((Event)new TeamChangeEvent(playerUUID, oldTeam, newTeam));
    }

    private static void postTeamAttributeChangeEvent(TPTeam team) {
        TPCommand.postTeamMemberChangeEvent(null, team, null);
    }

    private static /* synthetic */ void lambda$accept$9(Component component, ServerPlayer p) {
        p.m_213846_(component);
    }
}

