/*
 * Decompiled with CFR 0.152.
 */
package cn.leomc.teamprojecte;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public interface EMCData {
    public BigInteger getEMC(UUID var1);

    public void setEMC(BigInteger var1, UUID var2);

    public void removeMember(UUID var1);

    public EMCData convert(UUID var1);

    public void load(CompoundTag var1);

    public CompoundTag save();

    public static EMCData of(CompoundTag tag) {
        EMCData data = null;
        String type = tag.m_128461_("type");
        if (Sharing.getType().equals(type)) {
            data = new Sharing();
        }
        if (NotSharing.getType().equals(type)) {
            data = new NotSharing();
        }
        if (data == null) {
            return new Sharing();
        }
        data.load(tag);
        return data;
    }

    public static class Sharing
    implements EMCData {
        private BigInteger emc = BigInteger.ZERO;

        @Override
        public BigInteger getEMC(UUID player) {
            return this.emc;
        }

        @Override
        public void setEMC(BigInteger emc, UUID player) {
            this.emc = emc;
        }

        @Override
        public void removeMember(UUID player) {
        }

        @Override
        public EMCData convert(UUID owner) {
            NotSharing data = new NotSharing();
            data.setEMC(this.emc, owner);
            return data;
        }

        @Override
        public void load(CompoundTag tag) {
            this.emc = new BigInteger(tag.m_128461_("emc"));
        }

        @Override
        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("emc", this.emc.toString());
            tag.m_128359_("type", Sharing.getType());
            return tag;
        }

        public static String getType() {
            return "sharing";
        }
    }

    public static class NotSharing
    implements EMCData {
        private final Map<UUID, BigInteger> emc = new HashMap<UUID, BigInteger>();

        @Override
        public BigInteger getEMC(UUID player) {
            return this.emc.getOrDefault(player, BigInteger.ZERO);
        }

        @Override
        public void setEMC(BigInteger emc, UUID player) {
            this.emc.put(player, emc);
        }

        @Override
        public void removeMember(UUID player) {
            this.emc.remove(player);
        }

        @Override
        public EMCData convert(UUID owner) {
            Sharing data = new Sharing();
            data.setEMC(this.emc.values().stream().reduce(BigInteger.ZERO, BigInteger::add), Util.f_137441_);
            return data;
        }

        @Override
        public void load(CompoundTag tag) {
            this.emc.clear();
            tag.m_128437_("emc", 10).forEach(t -> {
                CompoundTag ct = (CompoundTag)t;
                this.emc.put(ct.m_128342_("player"), new BigInteger(ct.m_128461_("emc")));
            });
        }

        @Override
        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            this.emc.forEach((uuid, emc) -> {
                CompoundTag t = new CompoundTag();
                t.m_128362_("player", uuid);
                t.m_128359_("emc", emc.toString());
                list.add((Object)t);
            });
            tag.m_128365_("emc", (Tag)list);
            tag.m_128359_("type", NotSharing.getType());
            return tag;
        }

        public static String getType() {
            return "not_sharing";
        }
    }
}

