/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.structures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.structures.DungeonRoom;
import wayoftime.bloodmagic.structures.DungeonRoomRegistry;
import wayoftime.bloodmagic.structures.StoneToOreProcessor;
import wayoftime.bloodmagic.util.BMLog;

public class Dungeon {
    /*
     * WARNING - void declaration
     */
    public static boolean placeStructureAtPosition(RandomSource rand, ServerLevel world, BlockPos pos) {
        String initialDoorName = "default";
        long startTime = System.nanoTime();
        HashMap<String, Map<Object, Object>> availableDoorMasterMap = new HashMap<String, Map<Object, Object>>();
        ArrayList<AreaDescriptor> descriptorList = new ArrayList<AreaDescriptor>();
        HashMap<BlockPos, Pair> roomMap = new HashMap<BlockPos, Pair>();
        StructurePlaceSettings settings = new StructurePlaceSettings();
        Mirror mir = Mirror.NONE;
        settings.m_74377_(mir);
        Rotation rot = Rotation.NONE;
        settings.m_74379_(rot);
        settings.m_74392_(true);
        settings.m_74383_((StructureProcessor)new StoneToOreProcessor(0.0f));
        settings.m_74402_(true);
        DungeonRoom room = Dungeon.getRandomRoom(rand);
        roomMap.put(pos, Pair.of((Object)room, (Object)settings.m_74374_()));
        descriptorList.addAll(room.getAreaDescriptors(settings, pos));
        Map<Direction, List<BlockPos>> availableDoorMap = new HashMap<Direction, List<BlockPos>>();
        availableDoorMasterMap.put(initialDoorName, availableDoorMap);
        for (Direction facing : Direction.values()) {
            Object doorList;
            if (availableDoorMap.containsKey(facing)) {
                doorList = (List<BlockPos>)availableDoorMap.get(facing);
                doorList.addAll(room.getDoorOffsetsForFacing(settings, initialDoorName, facing, pos));
                continue;
            }
            doorList = room.getDoorOffsetsForFacing(settings, initialDoorName, facing, pos);
            availableDoorMap.put(facing, (List<BlockPos>)doorList);
        }
        for (int i = 0; i < 100; ++i) {
            void var19_23;
            ArrayList typeList = new ArrayList(availableDoorMasterMap.keySet());
            String doorName = (String)typeList.get(rand.m_188503_(typeList.size()));
            availableDoorMap = null;
            if (availableDoorMasterMap.containsKey(doorName)) {
                availableDoorMap = (Map)availableDoorMasterMap.get(doorName);
            } else {
                availableDoorMap = new HashMap();
                availableDoorMasterMap.put(doorName, availableDoorMap);
            }
            ArrayList<Direction> facingList = new ArrayList<Direction>();
            for (Map.Entry entry : availableDoorMap.entrySet()) {
                if (entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
                facingList.add((Direction)entry.getKey());
            }
            Collections.shuffle(facingList);
            Pair removedDoor1 = null;
            Object var19_26 = null;
            BlockPos roomLocation = null;
            block3: for (Direction direction : facingList) {
                Direction[] oppositeDoorFacing = direction.m_122424_();
                List availableDoorList = (List)availableDoorMap.get(direction);
                Collections.shuffle(availableDoorList);
                Rotation randRotation = Rotation.values()[rand.m_188503_(Rotation.values().length)];
                settings.m_74379_(randRotation);
                DungeonRoom testingRoom = Dungeon.getRandomRoom(rand);
                List<BlockPos> otherDoorList = testingRoom.getDoorOffsetsForFacing(settings, doorName, (Direction)oppositeDoorFacing, BlockPos.f_121853_);
                if (otherDoorList == null || otherDoorList.isEmpty()) continue;
                Collections.shuffle(otherDoorList);
                BlockPos testDoor = otherDoorList.get(0);
                Iterator iterator = availableDoorList.iterator();
                if (!iterator.hasNext()) break;
                BlockPos availableDoor = (BlockPos)iterator.next();
                roomLocation = availableDoor.m_121996_((Vec3i)testDoor).m_121955_(direction.m_122436_());
                List<AreaDescriptor> descriptors = testingRoom.getAreaDescriptors(settings, roomLocation);
                for (AreaDescriptor testDesc : descriptors) {
                    for (AreaDescriptor currentDesc : descriptorList) {
                        if (!testDesc.intersects(currentDesc)) continue;
                        break block3;
                    }
                }
                settings.m_74394_();
                settings.m_74383_((StructureProcessor)new StoneToOreProcessor(testingRoom.oreDensity));
                roomMap.put(roomLocation, Pair.of((Object)testingRoom, (Object)settings.m_74374_()));
                descriptorList.addAll(descriptors);
                removedDoor1 = Pair.of((Object)direction, (Object)availableDoor);
                Pair pair = Pair.of((Object)oppositeDoorFacing, (Object)testDoor.m_121955_((Vec3i)roomLocation));
                room = testingRoom;
                break;
            }
            if (removedDoor1 != null) {
                for (String string : room.doorMap.keySet()) {
                    availableDoorMap = null;
                    if (availableDoorMasterMap.containsKey(string)) {
                        availableDoorMap = (Map)availableDoorMasterMap.get(string);
                    } else {
                        availableDoorMap = new HashMap();
                        availableDoorMasterMap.put(string, availableDoorMap);
                    }
                    for (Direction facing : Direction.values()) {
                        List<BlockPos> doorList;
                        if (availableDoorMap.containsKey(facing)) {
                            doorList = (List<BlockPos>)availableDoorMap.get(facing);
                            doorList.addAll(room.getDoorOffsetsForFacing(settings, string, facing, roomLocation));
                            continue;
                        }
                        doorList = room.getDoorOffsetsForFacing(settings, string, facing, roomLocation);
                        availableDoorMap.put(facing, doorList);
                    }
                    Direction face = (Direction)removedDoor1.getKey();
                    if (!availableDoorMap.containsKey(face)) continue;
                    ((List)availableDoorMap.get(face)).remove(removedDoor1.getRight());
                }
            }
            if (var19_23 == null) continue;
            Direction face = (Direction)var19_23.getKey();
            for (Map.Entry entry : availableDoorMasterMap.entrySet()) {
                availableDoorMap = (Map)entry.getValue();
                if (!availableDoorMap.containsKey(face)) continue;
                ((List)availableDoorMap.get(face)).remove(var19_23.getRight());
            }
        }
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        BMLog.DEBUG.info("Duration: " + duration + "(ns), " + duration / 1000000L + "(ms)", new Object[0]);
        for (Map.Entry entry : roomMap.entrySet()) {
            BlockPos placementPos = (BlockPos)entry.getKey();
            DungeonRoom placedRoom = (DungeonRoom)((Pair)entry.getValue()).getKey();
            StructurePlaceSettings structurePlaceSettings = (StructurePlaceSettings)((Pair)entry.getValue()).getValue();
            placedRoom.placeStructureAtPosition(rand, structurePlaceSettings, world, placementPos);
        }
        return false;
    }

    public static DungeonRoom getRandomRoom(RandomSource rand) {
        return DungeonRoomRegistry.getRandomDungeonRoom(rand);
    }
}

