/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.network.SetClientVelocityPacket;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;

@RitualRegister(value="speed")
public class RitualSpeed
extends Ritual {
    public static final String SPEED_RANGE = "sanicRange";
    public static final double vengefulWillDrain = 0.05;
    public static final double destructiveWillDrain = 0.05;
    public static final double rawWillDrain = 0.1;
    public static final double steadfastWillDrain = 0.05;
    public static final double corrosiveWillDrain = 0.05;

    public RitualSpeed() {
        super("ritualSpeed", 0, 1000, "ritual.bloodmagic.speedRitual");
        this.addBlockRange(SPEED_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-2, 1, -2), new BlockPos(3, 5, 3)));
        this.setMaximumVolumeAndDistanceOfRange(SPEED_RANGE, 0, 4, 5);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        double corrosiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.CORROSIVE, willConfig);
        double destructiveWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DESTRUCTIVE, willConfig);
        double rawWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.DEFAULT, willConfig);
        double steadfastWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.STEADFAST, willConfig);
        double vengefulWill = this.getWillRespectingConfig(world, pos, EnumDemonWillType.VENGEFUL, willConfig);
        AreaDescriptor speedRange = masterRitualStone.getBlockRange(SPEED_RANGE);
        double vengefulDrain = 0.0;
        double destructiveDrain = 0.0;
        double rawDrain = 0.0;
        double steadfastDrain = 0.0;
        double corrosiveDrain = 0.0;
        if (rawWill < 0.1) {
            rawWill = 0.0;
        }
        if (corrosiveWill < 0.05) {
            corrosiveWill = 0.0;
        }
        for (LivingEntity entity : world.m_45976_(LivingEntity.class, speedRange.getAABB(masterRitualStone.getMasterBlockPos()))) {
            boolean transportAdults;
            if (entity.m_6144_()) continue;
            boolean transportChildren = destructiveWill < 0.05;
            boolean bl = transportAdults = vengefulWill < 0.05;
            if (entity.m_6162_() && !transportChildren || !entity.m_6162_() && !transportAdults || entity instanceof Player && transportChildren ^ transportAdults) continue;
            if (!transportChildren) {
                destructiveWill -= 0.05;
                destructiveDrain += 0.05;
            }
            if (!transportAdults) {
                vengefulWill -= 0.05;
                vengefulDrain += 0.05;
            }
            double motionY = this.getVerticalSpeedForWill(rawWill);
            double speed = this.getHorizontalSpeedForWill(rawWill);
            Direction direction = masterRitualStone.getDirection();
            if (rawWill >= 0.1) {
                rawWill -= 0.1;
                rawDrain += 0.1;
            }
            if (corrosiveWill >= 0.05) {
                corrosiveDrain += 0.05;
                speed += this.getAdditionalHorizontalSpeedForWill(corrosiveWill -= 0.05);
            }
            Vec3 motion = entity.m_20184_();
            double motionX = motion.m_7096_();
            double motionZ = motion.m_7094_();
            entity.f_19789_ = 0.0f;
            switch (direction) {
                case NORTH: {
                    motionX = 0.0;
                    motionZ = -speed;
                    break;
                }
                case SOUTH: {
                    motionX = 0.0;
                    motionZ = speed;
                    break;
                }
                case WEST: {
                    motionX = -speed;
                    motionZ = 0.0;
                    break;
                }
                case EAST: {
                    motionX = speed;
                    motionZ = 0.0;
                    break;
                }
            }
            if (steadfastWill >= 0.05) {
                entity.m_7292_(new MobEffectInstance((MobEffect)BloodMagicPotions.SOFT_FALL.get(), 100, 0));
                steadfastWill -= 0.05;
                steadfastDrain += 0.05;
            }
            entity.m_20334_(motionX, motionY, motionZ);
            if (!(entity instanceof ServerPlayer)) continue;
            BloodMagic.packetHandler.sendTo(new SetClientVelocityPacket(motionX, motionY, motionZ), (ServerPlayer)entity);
        }
        if (rawDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DEFAULT, rawDrain, true);
        }
        if (vengefulDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.VENGEFUL, vengefulDrain, true);
        }
        if (destructiveDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.DESTRUCTIVE, destructiveDrain, true);
        }
        if (steadfastDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.STEADFAST, steadfastDrain, true);
        }
        if (corrosiveDrain > 0.0) {
            WorldDemonWillHandler.drainWill(world, pos, EnumDemonWillType.CORROSIVE, corrosiveDrain, true);
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 5;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addRune(components, 0, 0, -2, EnumRuneType.DUSK);
        this.addRune(components, 1, 0, -1, EnumRuneType.AIR);
        this.addRune(components, -1, 0, -1, EnumRuneType.AIR);
        for (int i = 0; i < 3; ++i) {
            this.addRune(components, 2, 0, i, EnumRuneType.AIR);
            this.addRune(components, -2, 0, i, EnumRuneType.AIR);
        }
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualSpeed();
    }

    @Override
    public Component[] provideInformationOfRitualToPlayer(Player player) {
        return new Component[]{Component.m_237115_((String)(this.getTranslationKey() + ".info")), Component.m_237115_((String)(this.getTranslationKey() + ".default.info")), Component.m_237115_((String)(this.getTranslationKey() + ".corrosive.info")), Component.m_237115_((String)(this.getTranslationKey() + ".steadfast.info")), Component.m_237115_((String)(this.getTranslationKey() + ".destructive.info")), Component.m_237115_((String)(this.getTranslationKey() + ".vengeful.info"))};
    }

    public double getVerticalSpeedForWill(double rawWill) {
        return 1.2 + rawWill / 200.0;
    }

    public double getHorizontalSpeedForWill(double rawWill) {
        return 3.0 + rawWill / 40.0;
    }

    public double getAdditionalHorizontalSpeedForWill(double corrosiveWill) {
        return corrosiveWill / 40.0;
    }
}

