/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="full_stomach")
public class RitualFullStomach
extends Ritual {
    public static final String FILL_RANGE = "fillRange";
    public static final String CHEST_RANGE = "chest";
    public int foodLevel = 0;
    public float storedSaturation = 0.0f;

    public RitualFullStomach() {
        super("ritualFullStomach", 0, 100000, "ritual.bloodmagic.fullStomachRitual");
        this.addBlockRange(FILL_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-25, -25, -25), 51));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(FILL_RANGE, 0, 25, 25);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        if (this.getRefreshCost() > currentEssence) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        AreaDescriptor chestRange = masterRitualStone.getBlockRange(CHEST_RANGE);
        BlockEntity tile = world.m_7702_(chestRange.getContainedPositions(pos).get(0));
        if (tile == null) {
            return;
        }
        IItemHandler inventory = Utils.getInventory(tile, null);
        if (inventory == null) {
            return;
        }
        int lastSlot = 0;
        AreaDescriptor fillingRange = masterRitualStone.getBlockRange(FILL_RANGE);
        List playerList = world.m_45976_(Player.class, fillingRange.getAABB(pos));
        if (this.foodLevel <= 0) {
            for (int i = lastSlot; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.extractItem(i, 1, true);
                if (stack.m_41619_() || !stack.m_41720_().m_41472_()) continue;
                FoodProperties food = stack.m_41720_().m_41473_();
                this.foodLevel = food.m_38744_();
                this.storedSaturation = food.m_38745_();
                inventory.extractItem(i, 1, false);
                masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                break;
            }
            if (this.foodLevel <= 0) {
                return;
            }
        }
        for (Player player : playerList) {
            FoodData foodStats = player.m_36324_();
            float satLevel = foodStats.m_38722_();
            float saturationAmount = this.storedSaturation * 1.0f * 2.0f;
            while ((saturationAmount + satLevel <= 20.0f || satLevel < 5.0f) && this.foodLevel > 0) {
                foodStats.m_38707_(1, this.storedSaturation);
                satLevel = foodStats.m_38722_();
                --this.foodLevel;
            }
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.foodLevel = tag.m_128451_("foodLevel");
        this.storedSaturation = tag.m_128457_("storedSaturation");
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128405_("foodLevel", this.foodLevel);
        tag.m_128350_("storedSaturation", this.storedSaturation);
    }

    @Override
    public int getRefreshTime() {
        return 20;
    }

    @Override
    public int getRefreshCost() {
        return 100;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 3, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 1, 0, EnumRuneType.AIR);
        this.addOffsetRunes(components, 1, 2, 0, EnumRuneType.AIR);
        this.addCornerRunes(components, 4, 0, EnumRuneType.WATER);
        this.addOffsetRunes(components, 4, 3, 0, EnumRuneType.EARTH);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualFullStomach();
    }
}

