/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.item.inventory.InventoryFilter;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;
import wayoftime.bloodmagic.common.item.routing.IItemFilterProvider;
import wayoftime.bloodmagic.common.routing.IItemFilter;
import wayoftime.bloodmagic.common.tile.TileAlchemyTable;
import wayoftime.bloodmagic.common.tile.TileSoulForge;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.recipe.RecipeAlchemyTable;
import wayoftime.bloodmagic.recipe.RecipeTartaricForge;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="crafting")
public class RitualCrafting
extends Ritual {
    public static final String OUTPUT_CHEST_RANGE = "outputRange";
    public static final String INPUT_CHEST_RANGE = "inputRange";
    public static final String RECIPE_CHEST_RANGE = "recipeRange";
    public static final String OUTPUT_FILTER_RANGE = "outputFilterRange";
    public static final String HELLFORGED_RANGE = "hellforgedRange";
    public static final int CRAFTING_MODE = 0;
    public static final int HELLFORGE_MODE = 1;
    public static final int ALCHEMY_TABLE_MODE = 2;
    public static final double MAX_STEADFAST_DRAIN = 0.1;
    public static final double steadfastWillDrain = 0.01;
    public static final double MAX_CORROSIVE_DRAIN = 0.1;
    public static final double corrosiveWillDrain = 0.01;

    public RitualCrafting() {
        super("ritualCrafting", 0, 15000, "ritual.bloodmagic.craftingRitual");
        this.addBlockRange(OUTPUT_CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.addBlockRange(INPUT_CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.addBlockRange(RECIPE_CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 2, 0), 1));
        this.addBlockRange(OUTPUT_FILTER_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 0, 0), 1));
        this.addBlockRange(HELLFORGED_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 5, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(OUTPUT_CHEST_RANGE, 1, 7, 7);
        this.setMaximumVolumeAndDistanceOfRange(INPUT_CHEST_RANGE, 1, 7, 7);
        this.setMaximumVolumeAndDistanceOfRange(RECIPE_CHEST_RANGE, 1, 7, 7);
        this.setMaximumVolumeAndDistanceOfRange(OUTPUT_FILTER_RANGE, 1, 7, 7);
        this.setMaximumVolumeAndDistanceOfRange(HELLFORGED_RANGE, 1, 7, 7);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        BlockEntity alchemyTile;
        AreaDescriptor forgeDesc;
        int operations;
        BlockEntity forgeTile;
        AreaDescriptor forgeDesc2;
        List<BlockPos> forgePosList;
        Level level = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        List<EnumDemonWillType> willConfig = masterRitualStone.getActiveWillConfig();
        int mode = 0;
        if (willConfig.contains((Object)EnumDemonWillType.STEADFAST)) {
            double steadfastWill = this.getWillRespectingConfig(level, pos, EnumDemonWillType.STEADFAST, willConfig);
            mode = 1;
            if (steadfastWill < 0.1) {
                return;
            }
        } else if (willConfig.contains((Object)EnumDemonWillType.CORROSIVE)) {
            double corrosiveWill = this.getWillRespectingConfig(level, pos, EnumDemonWillType.CORROSIVE, willConfig);
            mode = 2;
            if (corrosiveWill < 0.1) {
                return;
            }
        }
        if (mode == 0) {
            this.attemptVanillaCrafting(masterRitualStone, level, pos);
        }
        if (mode == 1 && !(forgePosList = (forgeDesc2 = masterRitualStone.getBlockRange(HELLFORGED_RANGE)).getContainedPositions(pos)).isEmpty() && (forgeTile = level.m_7702_(forgePosList.get(0))) instanceof TileSoulForge && (operations = this.attemptHellforgedCrafting(masterRitualStone, level, pos, (TileSoulForge)forgeTile)) > 0) {
            double steadfastDrained = Math.min((double)operations * 0.01, 0.1);
            WorldDemonWillHandler.drainWill(level, pos, EnumDemonWillType.STEADFAST, steadfastDrained, true);
        }
        if (mode == 2 && !(forgePosList = (forgeDesc = masterRitualStone.getBlockRange(HELLFORGED_RANGE)).getContainedPositions(pos)).isEmpty() && (alchemyTile = level.m_7702_(forgePosList.get(0))) instanceof TileAlchemyTable) {
            if (((TileAlchemyTable)alchemyTile).isSlave()) {
                BlockEntity tile = level.m_7702_(((TileAlchemyTable)alchemyTile).getConnectedPos());
                if (tile instanceof TileAlchemyTable && !((TileAlchemyTable)tile).isSlave) {
                    alchemyTile = tile;
                } else {
                    return;
                }
            }
            if ((operations = this.attemptAlchemyTableCrafting(masterRitualStone, level, pos, (TileAlchemyTable)alchemyTile)) > 0) {
                double corrosiveDrained = Math.min((double)operations * 0.01, 0.1);
                WorldDemonWillHandler.drainWill(level, pos, EnumDemonWillType.CORROSIVE, corrosiveDrained, true);
            }
        }
    }

    public int attemptAlchemyTableCrafting(IMasterRitualStone masterRitualStone, Level level, BlockPos pos, TileAlchemyTable alchemyTable) {
        RecipeAlchemyTable recipe;
        ItemStack filterStack = this.getRecipeFilterStack(masterRitualStone, level, pos);
        if (filterStack.m_41619_()) {
            return 0;
        }
        IItemHandler inputInv = this.getInputInventory(masterRitualStone, level, pos);
        if (inputInv == null) {
            return 0;
        }
        InventoryFilter filterInv = new InventoryFilter(filterStack);
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>(4);
        int slotsFilled = 0;
        for (int i = 0; i < filterInv.m_6643_(); ++i) {
            ItemStack containedStack = filterInv.m_8020_(i);
            if (containedStack.m_41619_()) continue;
            inputList.add(containedStack);
            if (slotsFilled >= 4) break;
        }
        if ((recipe = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getAlchemyTable(level, inputList)) == null) {
            return 0;
        }
        int operations = 0;
        AreaDescriptor outputDesc = masterRitualStone.getBlockRange(OUTPUT_CHEST_RANGE);
        List<BlockPos> outputPosList = outputDesc.getContainedPositions(pos);
        BlockEntity outputTile = null;
        IItemHandler outputInv = null;
        BlockPos outputPos = pos;
        if (!outputPosList.isEmpty()) {
            outputPos = outputPosList.get(0);
            outputTile = level.m_7702_(outputPos);
        } else {
            outputPos = pos.m_6630_(2);
        }
        if (outputTile != null) {
            outputInv = Utils.getInventory(outputTile, null);
        }
        ArrayList<ItemStack> insertionList = new ArrayList<ItemStack>();
        IItemFilter itemRecipeFilter = ((IItemFilterProvider)filterStack.m_41720_()).getUninitializedItemFilter(filterStack);
        List<IFilterKey> filterKeyList = itemRecipeFilter.getFilterList();
        for (int slot = 0; slot < 6; ++slot) {
            boolean hasKey = filterKeyList.size() > slot;
            ItemStack containedStack = alchemyTable.m_8020_(slot);
            if (containedStack.m_41619_()) continue;
            if (hasKey) {
                IFilterKey key = filterKeyList.get(slot);
                if (key.doesStackMatch(containedStack)) continue;
                insertionList.add(alchemyTable.m_7407_(slot, containedStack.m_41613_()));
                ++operations;
                continue;
            }
            insertionList.add(alchemyTable.m_7407_(slot, containedStack.m_41613_()));
            ++operations;
        }
        ItemStack outputTableStack = alchemyTable.m_8020_(7);
        if (!outputTableStack.m_41619_()) {
            insertionList.add(alchemyTable.m_7407_(7, outputTableStack.m_41613_()));
        }
        ItemStack outputFilterStack = this.getOutputFilterStack(masterRitualStone, level, pos);
        ItemStack recipeOutputStack = recipe.getOutput();
        boolean doLimit = false;
        int craftLimit = 0;
        if (!outputFilterStack.m_41619_()) {
            IItemFilter outputFilter = ((IItemFilterProvider)outputFilterStack.m_41720_()).getUninitializedItemFilter(outputFilterStack);
            Iterator keyList = outputFilter.getFilterList();
            Iterator<Object> iterator = keyList.iterator();
            while (iterator.hasNext()) {
                IFilterKey outputKey = (IFilterKey)iterator.next();
                int count = outputKey.getCount();
                if (count == 0) {
                    doLimit = false;
                    break;
                }
                doLimit = true;
                craftLimit += Math.abs(count);
            }
            if (doLimit) {
                craftLimit += recipeOutputStack.m_41613_() - 2;
            }
        }
        boolean doCraft = true;
        if (outputInv != null) {
            doCraft = false;
            if (Utils.canInsertStackFullyIntoInventory(recipeOutputStack, outputInv, doLimit, craftLimit)) {
                doCraft = true;
            }
        }
        if (outputInv != null) {
            for (ItemStack insertedStack : insertionList) {
                ItemStack remainder = Utils.insertStackIntoTile(insertedStack, outputInv, true);
                if (remainder.m_41619_()) continue;
                Utils.spawnStackAtBlock(level, outputPos, Direction.UP, remainder);
            }
        } else {
            for (ItemStack insertedStack : insertionList) {
                Utils.spawnStackAtBlock(level, outputPos, Direction.UP, insertedStack);
            }
        }
        if (!doCraft) {
            return operations;
        }
        int tableSlot = 0;
        for (IFilterKey filterKey : filterKeyList) {
            ItemStack forgeStack = alchemyTable.m_8020_(tableSlot);
            if (!forgeStack.m_41619_()) {
                ++tableSlot;
                continue;
            }
            boolean hasSucceeded = false;
            for (int invSlot = 0; invSlot < inputInv.getSlots(); ++invSlot) {
                ItemStack extractedStack;
                ItemStack invStack = inputInv.getStackInSlot(invSlot);
                if (!filterKey.doesStackMatch(invStack) || (extractedStack = inputInv.extractItem(invSlot, 1, false)).m_41619_()) continue;
                alchemyTable.m_6836_(tableSlot, extractedStack);
                ++operations;
                hasSucceeded = true;
                break;
            }
            ++tableSlot;
            if (hasSucceeded) continue;
            return operations;
        }
        return operations;
    }

    public int attemptHellforgedCrafting(IMasterRitualStone masterRitualStone, Level level, BlockPos pos, TileSoulForge soulForge) {
        RecipeTartaricForge recipe;
        ItemStack filterStack = this.getRecipeFilterStack(masterRitualStone, level, pos);
        if (filterStack.m_41619_()) {
            return 0;
        }
        IItemHandler inputInv = this.getInputInventory(masterRitualStone, level, pos);
        if (inputInv == null) {
            return 0;
        }
        InventoryFilter filterInv = new InventoryFilter(filterStack);
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>(4);
        int slotsFilled = 0;
        for (int i = 0; i < filterInv.m_6643_(); ++i) {
            ItemStack containedStack = filterInv.m_8020_(i);
            if (containedStack.m_41619_()) continue;
            inputList.add(containedStack);
            if (slotsFilled >= 4) break;
        }
        if ((recipe = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getTartaricForge(level, inputList)) == null) {
            return 0;
        }
        int operations = 0;
        AreaDescriptor outputDesc = masterRitualStone.getBlockRange(OUTPUT_CHEST_RANGE);
        List<BlockPos> outputPosList = outputDesc.getContainedPositions(pos);
        BlockEntity outputTile = null;
        IItemHandler outputInv = null;
        BlockPos outputPos = pos;
        if (!outputPosList.isEmpty()) {
            outputPos = outputPosList.get(0);
            outputTile = level.m_7702_(outputPos);
        } else {
            outputPos = pos.m_6630_(2);
        }
        if (outputTile != null) {
            outputInv = Utils.getInventory(outputTile, null);
        }
        ArrayList<ItemStack> insertionList = new ArrayList<ItemStack>();
        IItemFilter itemRecipeFilter = ((IItemFilterProvider)filterStack.m_41720_()).getUninitializedItemFilter(filterStack);
        List<IFilterKey> filterKeyList = itemRecipeFilter.getFilterList();
        for (int slot = 0; slot < 4; ++slot) {
            boolean hasKey = filterKeyList.size() > slot;
            ItemStack containedStack = soulForge.m_8020_(slot);
            if (containedStack.m_41619_()) continue;
            if (hasKey) {
                IFilterKey key = filterKeyList.get(slot);
                if (key.doesStackMatch(containedStack)) continue;
                insertionList.add(soulForge.m_7407_(slot, containedStack.m_41613_()));
                ++operations;
                continue;
            }
            insertionList.add(soulForge.m_7407_(slot, containedStack.m_41613_()));
            ++operations;
        }
        ItemStack outputForgeStack = soulForge.m_8020_(5);
        if (!outputForgeStack.m_41619_()) {
            insertionList.add(soulForge.m_7407_(5, outputForgeStack.m_41613_()));
        }
        ItemStack outputFilterStack = this.getOutputFilterStack(masterRitualStone, level, pos);
        ItemStack recipeOutputStack = recipe.getOutput();
        boolean doLimit = false;
        int craftLimit = 0;
        if (!outputFilterStack.m_41619_()) {
            IItemFilter outputFilter = ((IItemFilterProvider)outputFilterStack.m_41720_()).getUninitializedItemFilter(outputFilterStack);
            Iterator keyList = outputFilter.getFilterList();
            Iterator<Object> iterator = keyList.iterator();
            while (iterator.hasNext()) {
                IFilterKey outputKey = (IFilterKey)iterator.next();
                int count = outputKey.getCount();
                if (count == 0) {
                    doLimit = false;
                    break;
                }
                doLimit = true;
                craftLimit += Math.abs(count);
            }
            if (doLimit) {
                craftLimit += recipeOutputStack.m_41613_() - 2;
            }
        }
        boolean doCraft = true;
        if (outputInv != null) {
            doCraft = false;
            if (Utils.canInsertStackFullyIntoInventory(recipeOutputStack, outputInv, doLimit, craftLimit)) {
                doCraft = true;
            }
        }
        if (outputInv != null) {
            for (ItemStack insertedStack : insertionList) {
                ItemStack remainder = Utils.insertStackIntoTile(insertedStack, outputInv, true);
                if (remainder.m_41619_()) continue;
                Utils.spawnStackAtBlock(level, outputPos, Direction.UP, remainder);
            }
        } else {
            for (ItemStack insertedStack : insertionList) {
                Utils.spawnStackAtBlock(level, outputPos, Direction.UP, insertedStack);
            }
        }
        if (!doCraft) {
            return operations;
        }
        int forgeSlot = 0;
        for (IFilterKey filterKey : filterKeyList) {
            ItemStack forgeStack = soulForge.m_8020_(forgeSlot);
            if (!forgeStack.m_41619_()) {
                ++forgeSlot;
                continue;
            }
            boolean hasSucceeded = false;
            for (int invSlot = 0; invSlot < inputInv.getSlots(); ++invSlot) {
                ItemStack extractedStack;
                ItemStack invStack = inputInv.getStackInSlot(invSlot);
                if (!filterKey.doesStackMatch(invStack) || (extractedStack = inputInv.extractItem(invSlot, 1, false)).m_41619_()) continue;
                soulForge.m_6836_(forgeSlot, extractedStack);
                ++operations;
                hasSucceeded = true;
                break;
            }
            ++forgeSlot;
            if (hasSucceeded) continue;
            return operations;
        }
        return operations;
    }

    public void attemptVanillaCrafting(IMasterRitualStone masterRitualStone, Level level, BlockPos pos) {
        ItemStack filterStack = this.getRecipeFilterStack(masterRitualStone, level, pos);
        if (filterStack.m_41619_()) {
            return;
        }
        IItemHandler inputInv = this.getInputInventory(masterRitualStone, level, pos);
        if (inputInv == null) {
            return;
        }
        InventoryFilter filterInv = new InventoryFilter(filterStack);
        CraftingContainer craftingContainer = RitualCrafting.makeContainer();
        for (int i = 0; i < filterInv.m_6643_(); ++i) {
            craftingContainer.m_6836_(i, filterInv.m_8020_(i));
        }
        List craftingRecipes = level.m_7465_().m_44056_(RecipeType.f_44107_, (Container)craftingContainer, level);
        if (craftingRecipes.isEmpty()) {
            return;
        }
        CraftingRecipe recipe = (CraftingRecipe)craftingRecipes.get(0);
        ItemStack outputFilterStack = this.getOutputFilterStack(masterRitualStone, level, pos);
        boolean doLimit = false;
        int craftLimit = 0;
        if (!outputFilterStack.m_41619_()) {
            IItemFilter outputFilter = ((IItemFilterProvider)outputFilterStack.m_41720_()).getUninitializedItemFilter(outputFilterStack);
            if (craftingRecipes.size() > 1) {
                boolean foundRecipe = false;
                for (CraftingRecipe testRecipe : craftingRecipes) {
                    ItemStack resultStack = testRecipe.m_8043_(level.m_9598_());
                    if (!outputFilter.doesStackPassFilter(resultStack)) continue;
                    recipe = testRecipe;
                    foundRecipe = true;
                    break;
                }
                if (!foundRecipe) {
                    return;
                }
            }
            List<IFilterKey> keyList = outputFilter.getFilterList();
            for (IFilterKey outputKey : keyList) {
                int count = outputKey.getCount();
                if (count == 0) {
                    doLimit = false;
                    break;
                }
                doLimit = true;
                craftLimit += Math.abs(count);
            }
            if (doLimit) {
                craftLimit += recipe.m_8043_(level.m_9598_()).m_41613_() - 1;
            }
        }
        IItemFilter itemRecipeFilter = ((IItemFilterProvider)filterStack.m_41720_()).getUninitializedItemFilter(filterStack);
        HashMap<Integer, Integer> selectedMap = new HashMap<Integer, Integer>();
        List<IFilterKey> filterKeyList = itemRecipeFilter.getFilterList();
        int filterKeyIndex = 0;
        for (int filterSlot = 0; filterSlot < Math.min(filterInv.m_6643_(), 9); ++filterSlot) {
            ItemStack filterKeyStack = filterInv.m_8020_(filterSlot);
            if (filterKeyStack.m_41619_()) continue;
            if (filterKeyIndex >= filterKeyList.size()) {
                return;
            }
            boolean hasSucceeded = false;
            IFilterKey filterKey = filterKeyList.get(filterKeyIndex);
            for (int invSlot = 0; invSlot < inputInv.getSlots(); ++invSlot) {
                ItemStack extractedStack;
                ItemStack invStack = inputInv.getStackInSlot(invSlot);
                int claimedAmount = selectedMap.getOrDefault(invSlot, 0);
                if (invStack.m_41613_() < claimedAmount + 1 || !filterKey.doesStackMatch(invStack) || (extractedStack = inputInv.extractItem(invSlot, 1, true)).m_41619_()) continue;
                selectedMap.put(invSlot, 1 + claimedAmount);
                craftingContainer.m_6836_(filterSlot, extractedStack);
                hasSucceeded = true;
                break;
            }
            ++filterKeyIndex;
            if (hasSucceeded) continue;
            return;
        }
        AreaDescriptor outputDesc = masterRitualStone.getBlockRange(OUTPUT_CHEST_RANGE);
        List<BlockPos> outputPosList = outputDesc.getContainedPositions(pos);
        BlockEntity outputTile = null;
        IItemHandler outputInv = null;
        BlockPos outputPos = pos;
        if (!outputPosList.isEmpty()) {
            outputPos = outputPosList.get(0);
            outputTile = level.m_7702_(outputPos);
        } else {
            outputPos = pos.m_6630_(2);
        }
        if (outputTile != null) {
            outputInv = Utils.getInventory(outputTile, null);
        }
        ItemStack resultStack = recipe.m_5874_((Container)craftingContainer, level.m_9598_());
        boolean doCraft = true;
        if (outputInv != null) {
            doCraft = false;
            if (Utils.canInsertStackFullyIntoInventory(resultStack, outputInv, doLimit, craftLimit)) {
                doCraft = true;
            }
        }
        if (doCraft) {
            ArrayList<ItemStack> insertionList = new ArrayList<ItemStack>();
            insertionList.add(resultStack);
            for (Map.Entry syphonEntry : selectedMap.entrySet()) {
                int syphonAmount;
                int slot = (Integer)syphonEntry.getKey();
                ItemStack syphonStack = inputInv.extractItem(slot, syphonAmount = ((Integer)syphonEntry.getValue()).intValue(), false);
                if (!syphonStack.hasCraftingRemainingItem()) continue;
                ItemStack containedStack = syphonStack.getCraftingRemainingItem();
                if (inputInv.isItemValid(slot, containedStack)) {
                    ItemStack remainderStack = inputInv.insertItem(slot, containedStack, false);
                    if (remainderStack.m_41619_()) continue;
                    insertionList.add(remainderStack);
                    continue;
                }
                insertionList.add(containedStack);
            }
            if (outputInv != null) {
                for (ItemStack insertedStack : insertionList) {
                    ItemStack remainder = Utils.insertStackIntoTile(insertedStack, outputInv, true);
                    if (remainder.m_41619_()) continue;
                    Utils.spawnStackAtBlock(level, outputPos, Direction.UP, remainder);
                }
            } else {
                for (ItemStack insertedStack : insertionList) {
                    Utils.spawnStackAtBlock(level, outputPos, Direction.UP, insertedStack);
                }
            }
            masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
        }
    }

    public ItemStack getRecipeFilterStack(IMasterRitualStone masterRitualStone, Level level, BlockPos masterPos) {
        ItemStack filterStack;
        block2: {
            IItemHandler inv;
            BlockEntity tile;
            AreaDescriptor recipeDesc;
            block3: {
                filterStack = ItemStack.f_41583_;
                recipeDesc = masterRitualStone.getBlockRange(RECIPE_CHEST_RANGE);
                List itemFrames = level.m_45976_(ItemFrame.class, recipeDesc.getAABB(masterPos));
                if (itemFrames.isEmpty()) break block3;
                for (ItemFrame frame : itemFrames) {
                    ItemStack frameStack = frame.m_31822_();
                    if (frameStack.m_41619_() || !(frameStack.m_41720_() instanceof IItemFilterProvider)) continue;
                    filterStack = frameStack;
                }
                break block2;
            }
            List<BlockPos> posList = recipeDesc.getContainedPositions(masterPos);
            if (posList.isEmpty() || (tile = level.m_7702_(posList.get(0))) == null || (inv = Utils.getInventory(tile, null)) == null) break block2;
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack frameStack = inv.getStackInSlot(i);
                if (frameStack.m_41619_() || !(frameStack.m_41720_() instanceof IItemFilterProvider)) continue;
                filterStack = frameStack;
                break;
            }
        }
        return filterStack;
    }

    public IItemHandler getInputInventory(IMasterRitualStone masterRitualStone, Level level, BlockPos masterPos) {
        AreaDescriptor inputDesc = masterRitualStone.getBlockRange(INPUT_CHEST_RANGE);
        List<BlockPos> inputPosList = inputDesc.getContainedPositions(masterPos);
        BlockEntity inputTile = null;
        if (!inputPosList.isEmpty()) {
            inputTile = level.m_7702_(inputPosList.get(0));
        }
        if (inputTile == null) {
            return null;
        }
        return Utils.getInventory(inputTile, null);
    }

    public ItemStack getOutputFilterStack(IMasterRitualStone masterRitualStone, Level level, BlockPos masterPos) {
        ItemStack outputFilterStack;
        block2: {
            IItemHandler inv;
            BlockEntity tile;
            AreaDescriptor outputFilterDesc;
            block3: {
                outputFilterDesc = masterRitualStone.getBlockRange(OUTPUT_FILTER_RANGE);
                outputFilterStack = ItemStack.f_41583_;
                List outputFrames = level.m_45976_(ItemFrame.class, outputFilterDesc.getAABB(masterPos));
                if (outputFrames == null) break block3;
                for (ItemFrame frame : outputFrames) {
                    ItemStack frameStack = frame.m_31822_();
                    if (frameStack.m_41619_() || !(frameStack.m_41720_() instanceof IItemFilterProvider)) continue;
                    outputFilterStack = frameStack;
                }
                break block2;
            }
            List<BlockPos> posList = outputFilterDesc.getContainedPositions(masterPos);
            if (posList.isEmpty() || (tile = level.m_7702_(posList.get(0))) == null || (inv = Utils.getInventory(tile, null)) == null) break block2;
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack frameStack = inv.getStackInSlot(i);
                if (frameStack.m_41619_() || !(frameStack.m_41720_() instanceof IItemFilterProvider)) continue;
                outputFilterStack = frameStack;
                break;
            }
        }
        return outputFilterStack;
    }

    private static CraftingContainer makeContainer() {
        TransientCraftingContainer craftingcontainer = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

            public ItemStack m_7648_(Player p_38941_, int p_38942_) {
                return null;
            }

            public boolean m_6875_(Player p_29888_) {
                return false;
            }
        }, 3, 3);
        return craftingcontainer;
    }

    @Override
    public int getRefreshTime() {
        return 4;
    }

    @Override
    public int getRefreshCost() {
        return 10;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 1, EnumRuneType.EARTH);
        this.addOffsetRunes(components, 1, 2, -1, EnumRuneType.FIRE);
        this.addCornerRunes(components, 1, -1, EnumRuneType.FIRE);
        this.addRune(components, -1, -1, 0, EnumRuneType.EARTH);
        this.addRune(components, 1, -1, 0, EnumRuneType.EARTH);
        this.addRune(components, 0, -1, -1, EnumRuneType.EARTH);
        this.addRune(components, 0, -1, 1, EnumRuneType.WATER);
        this.addRune(components, -1, 1, 0, EnumRuneType.EARTH);
        this.addRune(components, 1, 1, 0, EnumRuneType.EARTH);
        this.addRune(components, 0, 1, -1, EnumRuneType.EARTH);
        this.addRune(components, 0, 0, 1, EnumRuneType.EARTH);
        this.addRune(components, 0, 2, -1, EnumRuneType.DUSK);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualCrafting();
    }

    @Override
    public Component[] provideInformationOfRitualToPlayer(Player player) {
        return new Component[]{Component.m_237115_((String)(this.getTranslationKey() + ".info")), Component.m_237115_((String)(this.getTranslationKey() + ".steadfast.info")), Component.m_237115_((String)(this.getTranslationKey() + ".corrosive.info"))};
    }
}

