/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.IOUtils;
import wayoftime.bloodmagic.BloodMagic;

public class ResourceUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<Path> gatherResources(String home, String following, Predicate<Path> predicate) {
        FileSystem fileSystem = null;
        try {
            URL url = ResourceUtil.class.getResource(home);
            if (url != null) {
                Path path;
                URI uri = url.toURI();
                if (uri.getScheme().equals("file")) {
                    path = Paths.get(ResourceUtil.class.getResource(home + "/" + following).toURI());
                } else {
                    if (!uri.getScheme().equals("jar")) {
                        BloodMagic.LOGGER.error("Unsupported URI scheme {}", (Object)uri.getScheme());
                        Set<Path> set = Collections.emptySet();
                        IOUtils.closeQuietly((Closeable)fileSystem);
                        return set;
                    }
                    try {
                        fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    }
                    catch (FileSystemAlreadyExistsException e) {
                        fileSystem = FileSystems.getFileSystem(uri);
                    }
                    path = fileSystem.getPath(home + "/" + following, new String[0]);
                }
                Set<Path> set = Files.walk(path, new FileVisitOption[0]).filter(predicate).collect(Collectors.toSet());
                IOUtils.closeQuietly((Closeable)fileSystem);
                return set;
            }
            IOUtils.closeQuietly(fileSystem);
            return Collections.emptySet();
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            return Collections.emptySet();
        }
        finally {
            IOUtils.closeQuietly(fileSystem);
        }
    }

    public static Set<Path> gatherResources(String home, String following) {
        return ResourceUtil.gatherResources(home, following, p -> true);
    }

    public static ResourceLocation addContext(ResourceLocation rl, String context) {
        return new ResourceLocation(rl.m_135827_(), context + rl.m_135815_());
    }
}

