/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.patchouli.processors;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.recipe.RecipeARC;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class ARCProcessor
implements IComponentProcessor {
    private RecipeARC recipe;

    public void setup(Level level, IVariableProvider variables) {
        Recipe recipe;
        ResourceLocation id = new ResourceLocation(variables.get("recipe").asString());
        Optional recipeHandler = Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(id);
        if (recipeHandler.isPresent() && (recipe = (Recipe)recipeHandler.get()).m_6671_().equals(BloodMagicRecipeType.ARC.get())) {
            this.recipe = (RecipeARC)recipe;
        }
        if (this.recipe == null) {
            LogManager.getLogger().warn("Guidebook missing Alchemical Reaction Chamber recipe {}", (Object)id);
        }
    }

    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.startsWith("output")) {
            int index = Integer.parseInt(key.substring(6)) - 1;
            if (this.recipe.getAllListedOutputs().size() > index) {
                return IVariable.from((Object)this.recipe.getAllListedOutputs().get(index));
            }
            return null;
        }
        if (key.startsWith("chance")) {
            index = Integer.parseInt(key.substring(6)) - 2;
            if (this.recipe.getAllOutputChances().size() > index) {
                Pair<Double, Double> chances = this.recipe.getAllOutputChances().get(index);
                double chance = ((Double)chances.getLeft() + (Double)chances.getRight()) * 100.0;
                if (chance < 1.0) {
                    return IVariable.wrap((String)"<1");
                }
                return IVariable.wrap((Number)Math.round(chance));
            }
        } else if (key.startsWith("show_chance")) {
            index = Integer.parseInt(key.substring(11)) - 2;
            if (this.recipe.getAllOutputChances().size() > index) {
                return IVariable.wrap((Boolean)true);
            }
        }
        switch (key) {
            case "show_fluid_tooltip": {
                if (this.recipe.getFluidIngredient() != null || this.recipe.getFluidOutput() != FluidStack.EMPTY) {
                    return IVariable.wrap((Boolean)true);
                }
                return IVariable.wrap((Boolean)false);
            }
            case "input": {
                return IVariable.wrapList((Iterable)Arrays.stream(this.recipe.getInput().m_43908_()).map(IVariable::from).collect(Collectors.toList()));
            }
            case "tool": {
                return IVariable.wrapList((Iterable)Arrays.stream(this.recipe.getTool().m_43908_()).map(IVariable::from).collect(Collectors.toList()));
            }
            case "tooltip_fluid_input": {
                if (this.recipe.getFluidIngredient() != null) {
                    FluidStack fluid = (FluidStack)this.recipe.getFluidIngredient().getRepresentations().get(0);
                    String i18nFluidName = TextHelper.localize(fluid.getTranslationKey(), new Object[0]);
                    return IVariable.wrap((String)TextHelper.localize("guide.patchouli.bloodmagic.arc_processor.fluid", fluid.getAmount(), i18nFluidName));
                }
                return IVariable.wrap((String)TextHelper.localize("guide.patchouli.bloodmagic.arc_processor.no_fluid", new Object[0]));
            }
            case "tooltip_fluid_output": {
                if (this.recipe.getFluidOutput() != FluidStack.EMPTY) {
                    FluidStack fluid = this.recipe.getFluidOutput();
                    String i18nFluidName = TextHelper.localize(fluid.getTranslationKey(), new Object[0]);
                    return IVariable.wrap((String)TextHelper.localize("guide.patchouli.bloodmagic.arc_processor.fluid", fluid.getAmount(), i18nFluidName));
                }
                return IVariable.wrap((String)TextHelper.localize("guide.patchouli.bloodmagic.arc_processor.no_fluid", new Object[0]));
            }
        }
        return null;
    }
}

