/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import wayoftime.bloodmagic.recipe.RecipeTartaricForge;
import wayoftime.bloodmagic.recipe.helper.SerializerHelper;

public class TartaricForgeRecipeSerializer<RECIPE extends RecipeTartaricForge>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public TartaricForgeRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        for (int i = 0; i < 4; ++i) {
            if (!json.has("input" + i)) continue;
            JsonArray input = GsonHelper.m_13885_((JsonObject)json, (String)("input" + i)) ? GsonHelper.m_13933_((JsonObject)json, (String)("input" + i)) : GsonHelper.m_13930_((JsonObject)json, (String)("input" + i));
            inputList.add(Ingredient.m_43917_((JsonElement)input));
        }
        ItemStack output = SerializerHelper.getItemStack(json, "output");
        float minimumSouls = GsonHelper.m_13915_((JsonObject)json, (String)"minimumDrain");
        float soulDrain = GsonHelper.m_13915_((JsonObject)json, (String)"drain");
        return this.factory.create(recipeId, inputList, output, minimumSouls, soulDrain);
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<Ingredient> input = new ArrayList<Ingredient>(size);
        for (int i = 0; i < size; ++i) {
            input.add(i, Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }
        ItemStack output = buffer.m_130267_();
        double minimumSouls = buffer.readDouble();
        double soulDrain = buffer.readDouble();
        return this.factory.create(recipeId, input, output, minimumSouls, soulDrain);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull RECIPE recipe) {
        ((RecipeTartaricForge)recipe).write(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends RecipeTartaricForge> {
        public RECIPE create(ResourceLocation var1, List<Ingredient> var2, ItemStack var3, double var4, double var6);
    }
}

