/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWillGem;
import wayoftime.bloodmagic.common.loot.BloodMagicLootFunctionManager;

public class SetWillFraction
extends LootItemConditionalFunction {
    private static final Logger LOGGER = LogManager.getLogger();
    private final UniformGenerator damageRange;

    private SetWillFraction(LootItemCondition[] conditionsIn, UniformGenerator damageRangeIn) {
        super(conditionsIn);
        this.damageRange = damageRangeIn;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)BloodMagicLootFunctionManager.SET_WILL_FRACTION.get();
    }

    public ItemStack m_7372_(ItemStack stack, LootContext context) {
        if (stack.m_41720_() instanceof IDemonWillGem) {
            int maxWill = ((IDemonWillGem)stack.m_41720_()).getMaxWill(EnumDemonWillType.DEFAULT, stack);
            float f = 1.0f - this.damageRange.m_142688_(context);
            ((IDemonWillGem)stack.m_41720_()).setWill(EnumDemonWillType.DEFAULT, stack, (float)maxWill * f);
        } else {
            LOGGER.warn("Couldn't set will of loot item {}", (Object)stack);
        }
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> withRange(UniformGenerator p_215931_0_) {
        return SetWillFraction.m_80683_(p_215930_1_ -> new SetWillFraction((LootItemCondition[])p_215930_1_, p_215931_0_));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetWillFraction> {
        public void serialize(JsonObject p_230424_1_, SetWillFraction p_230424_2_, JsonSerializationContext p_230424_3_) {
            super.m_6170_(p_230424_1_, (LootItemConditionalFunction)p_230424_2_, p_230424_3_);
            p_230424_1_.add("damage", p_230424_3_.serialize((Object)p_230424_2_.damageRange));
        }

        public SetWillFraction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
            return new SetWillFraction(conditionsIn, (UniformGenerator)GsonHelper.m_13836_((JsonObject)object, (String)"damage", (JsonDeserializationContext)deserializationContext, UniformGenerator.class));
        }
    }
}

