/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.soul;

import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWill;
import wayoftime.bloodmagic.api.compat.IDemonWillGem;
import wayoftime.bloodmagic.api.compat.IMultiWillTool;
import wayoftime.bloodmagic.util.ChatUtil;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

public class ItemSoulGem
extends Item
implements IDemonWillGem,
IMultiWillTool {
    private final int maxWill;
    private final String name;

    public ItemSoulGem(String name, int maxWill) {
        super(new Item.Properties().m_41487_(1));
        this.name = name;
        this.maxWill = maxWill;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        EnumDemonWillType type = this.getCurrentType(stack);
        double drain = Math.min(this.getWill(type, stack), (double)(this.getMaxWill(type, stack) / 10));
        double filled = PlayerDemonWillHandler.addDemonWill(type, player, drain, stack);
        this.drainWill(type, stack, filled, true);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        if (!stack.m_41782_()) {
            return;
        }
        EnumDemonWillType type = this.getCurrentType(stack);
        tooltip.add((Component)Component.m_237115_((String)("tooltip.bloodmagic.soulGem." + this.name)).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.bloodmagic.will", (Object[])new Object[]{ChatUtil.DECIMAL_FORMAT.format(this.getWill(type, stack))}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)("tooltip.bloodmagic.currentType." + this.getCurrentType(stack).name().toLowerCase(Locale.ROOT))).m_130940_(ChatFormatting.GRAY));
        super.m_7373_(stack, world, tooltip, flag);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        EnumDemonWillType type = this.getCurrentType(stack);
        double maxWill = this.getMaxWill(type, stack);
        if (maxWill <= 0.0) {
            return 0;
        }
        return (int)(this.getWill(type, stack) * 13.0 / maxWill);
    }

    public int m_142159_(ItemStack stack) {
        EnumDemonWillType type = this.getCurrentType(stack);
        double maxWill = this.getMaxWill(type, stack);
        if (maxWill <= 0.0) {
            return 1;
        }
        return Mth.m_14169_((float)(Math.max(0.0f, (float)this.getWill(type, stack) / (float)maxWill) / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Override
    public ItemStack fillDemonWillGem(ItemStack soulGemStack, ItemStack soulStack) {
        if (soulStack != null && soulStack.m_41720_() instanceof IDemonWill) {
            EnumDemonWillType thisType = this.getCurrentType(soulGemStack);
            if (thisType != ((IDemonWill)soulStack.m_41720_()).getType(soulStack)) {
                return soulStack;
            }
            IDemonWill soul = (IDemonWill)soulStack.m_41720_();
            double soulsLeft = this.getWill(thisType, soulGemStack);
            if (soulsLeft < (double)this.getMaxWill(thisType, soulGemStack)) {
                double newSoulsLeft = Math.min(soulsLeft + soul.getWill(thisType, soulStack), (double)this.getMaxWill(thisType, soulGemStack));
                soul.drainWill(thisType, soulStack, newSoulsLeft - soulsLeft);
                this.setWill(thisType, soulGemStack, newSoulsLeft);
                if (soul.getWill(thisType, soulStack) <= 0.0) {
                    return ItemStack.f_41583_;
                }
            }
        }
        return soulStack;
    }

    @Override
    public double getWill(EnumDemonWillType type, ItemStack soulGemStack) {
        if (!type.equals((Object)this.getCurrentType(soulGemStack))) {
            return 0.0;
        }
        CompoundTag tag = soulGemStack.m_41783_();
        return tag.m_128459_("souls");
    }

    @Override
    public void setWill(EnumDemonWillType type, ItemStack soulGemStack, double souls) {
        this.setCurrentType(type, soulGemStack);
        CompoundTag tag = soulGemStack.m_41783_();
        tag.m_128347_("souls", souls);
    }

    @Override
    public double drainWill(EnumDemonWillType type, ItemStack soulGemStack, double drainAmount, boolean doDrain) {
        EnumDemonWillType currentType = this.getCurrentType(soulGemStack);
        if (currentType != type) {
            return 0.0;
        }
        double souls = this.getWill(type, soulGemStack);
        double soulsDrained = Math.min(drainAmount, souls);
        if (doDrain) {
            this.setWill(type, soulGemStack, souls - soulsDrained);
        }
        return soulsDrained;
    }

    @Override
    public int getMaxWill(EnumDemonWillType type, ItemStack soulGemStack) {
        EnumDemonWillType currentType = this.getCurrentType(soulGemStack);
        if (!type.equals((Object)currentType) && currentType != EnumDemonWillType.DEFAULT) {
            return 0;
        }
        return this.maxWill;
    }

    @Override
    public EnumDemonWillType getCurrentType(ItemStack soulGemStack) {
        NBTHelper.checkNBT(soulGemStack);
        CompoundTag tag = soulGemStack.m_41783_();
        if (!tag.m_128441_("demonWillType")) {
            return EnumDemonWillType.DEFAULT;
        }
        return EnumDemonWillType.valueOf(tag.m_128461_("demonWillType").toUpperCase(Locale.ROOT));
    }

    public void setCurrentType(EnumDemonWillType type, ItemStack soulGemStack) {
        NBTHelper.checkNBT(soulGemStack);
        CompoundTag tag = soulGemStack.m_41783_();
        if (type == EnumDemonWillType.DEFAULT) {
            if (tag.m_128441_("demonWillType")) {
                tag.m_128473_("demonWillType");
            }
            return;
        }
        tag.m_128359_("demonWillType", type.toString());
    }

    @Override
    public double fillWill(EnumDemonWillType type, ItemStack stack, double fillAmount, boolean doFill) {
        if (!type.equals((Object)this.getCurrentType(stack)) && this.getWill(this.getCurrentType(stack), stack) > 0.0) {
            return 0.0;
        }
        double current = this.getWill(type, stack);
        double maxWill = this.getMaxWill(type, stack);
        double filled = Math.min(fillAmount, maxWill - current);
        if (doFill) {
            this.setWill(type, stack, filled + current);
        }
        return filled;
    }
}

