/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.sigil;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.sigil.ISigil;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilBase;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.entity.projectile.EntityBloodLight;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.util.helper.NetworkHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

public class ItemSigilBloodLight
extends ItemSigilBase {
    public ItemSigilBloodLight() {
        super("bloodlight", 10);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.getCooldownRemainder(stack) > 0) {
            this.reduceCooldown(stack);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.m_41720_()).getHeldItem(stack, player);
        }
        if (PlayerHelper.isFakePlayer(player)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        BlockHitResult mop = ItemSigilBloodLight.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (this.getCooldownRemainder(stack) > 0) {
            return super.m_7203_(world, player, hand);
        }
        if (mop != null && mop.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockRayTrace = mop;
            BlockPos blockPos = blockRayTrace.m_82425_().m_121945_(blockRayTrace.m_82434_());
            if (world.m_46859_(blockPos)) {
                world.m_46597_(blockPos, ((Block)BloodMagicBlocks.BLOOD_LIGHT.get()).m_49966_());
                if (!world.f_46443_) {
                    SoulNetwork network = NetworkHelper.getSoulNetwork(this.getBinding(stack));
                    network.syphonAndDamage(player, SoulTicket.item(stack, world, (Entity)player, this.getLpUsed()));
                }
                this.resetCooldown(stack);
                player.m_6674_(hand);
                return super.m_7203_(world, player, hand);
            }
        } else {
            if (!world.f_46443_) {
                SoulNetwork network = NetworkHelper.getSoulNetwork(this.getBinding(stack));
                EntityBloodLight light = new EntityBloodLight(world, (LivingEntity)player);
                light.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
                world.m_7967_((Entity)light);
                network.syphonAndDamage(player, SoulTicket.item(stack, world, (Entity)player, this.getLpUsed()));
            }
            this.resetCooldown(stack);
        }
        return super.m_7203_(world, player, hand);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public int getCooldownRemainder(ItemStack stack) {
        return NBTHelper.checkNBT(stack).m_41783_().m_128451_("ticksRemaining");
    }

    public void reduceCooldown(ItemStack stack) {
        NBTHelper.checkNBT(stack).m_41783_().m_128405_("ticksRemaining", this.getCooldownRemainder(stack) - 1);
    }

    public void resetCooldown(ItemStack stack) {
        NBTHelper.checkNBT(stack).m_41783_().m_128405_("ticksRemaining", 10);
    }
}

