/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import wayoftime.bloodmagic.common.container.item.ContainerTrainingBracelet;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.inventory.InventoryTrainingBracelet;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.util.Utils;

public class ItemLivingTrainer
extends Item
implements ILivingContainer,
MenuProvider {
    public static final int MAX_SIZE = 16;

    public ItemLivingTrainer() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            Utils.setUUID(stack);
            ILivingContainer.setDisplayIfZero(stack, true);
            if (player instanceof ServerPlayer) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> buf.writeItemStack(stack, false));
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        if (stack.m_41783_() != null) {
            LivingStats stats = this.getLivingStats(stack);
            if (stats == null) {
                return;
            }
            boolean isWhitelist = this.getIsWhitelist(stack);
            if (isWhitelist) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.trainer.whitelist"));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.trainer.blacklist"));
            }
            HashMap<LivingUpgrade, Integer> positiveUpgradeMap = new HashMap<LivingUpgrade, Integer>();
            ArrayList zeroUpgradeList = new ArrayList();
            stats.getUpgrades().forEach((k, v) -> {
                int level = k.getLevel(v.intValue());
                if (level > 0) {
                    positiveUpgradeMap.put((LivingUpgrade)k, level);
                } else {
                    zeroUpgradeList.add(k);
                }
            });
            positiveUpgradeMap.forEach((k, v) -> tooltip.add((Component)Component.m_237110_((String)"%s %s", (Object[])new Object[]{Component.m_237115_((String)k.getTranslationKey()), Component.m_237115_((String)("enchantment.level." + v))}).m_130940_(ChatFormatting.GRAY)));
            if (!zeroUpgradeList.isEmpty() && !isWhitelist) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.bloodmagic.trainer.deny"));
                for (LivingUpgrade upgrade : zeroUpgradeList) {
                    tooltip.add((Component)Component.m_237115_((String)upgrade.getTranslationKey()).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
    }

    public void setIsWhitelist(ItemStack trainerStack, boolean isWhitelist) {
        if (trainerStack.m_41783_() == null) {
            trainerStack.m_41751_(new CompoundTag());
        }
        trainerStack.m_41783_().m_128379_("button:blackwhitelist", isWhitelist);
    }

    public boolean getIsWhitelist(ItemStack trainerStack) {
        if (trainerStack.m_41783_() == null) {
            trainerStack.m_41751_(new CompoundTag());
        }
        return trainerStack.m_41783_().m_128471_("button:blackwhitelist");
    }

    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player player) {
        assert (player.m_20193_() != null);
        return new ContainerTrainingBracelet(p_createMenu_1_, player, p_createMenu_2_, player.m_21205_());
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Bracelet");
    }

    public void setTomeLevel(ItemStack trainerStack, int slot, int desiredLevel) {
        InventoryTrainingBracelet inv = new InventoryTrainingBracelet(trainerStack);
        ItemStack tomeStack = inv.m_8020_(slot);
        if (!tomeStack.m_41619_() && tomeStack.m_41720_() instanceof ILivingContainer) {
            LivingStats tomeStats = ((ILivingContainer)tomeStack.m_41720_()).getLivingStats(tomeStack);
            if (tomeStats != null) {
                LivingStats newStats = new LivingStats();
                for (Map.Entry<LivingUpgrade, Double> entry : tomeStats.getUpgrades().entrySet()) {
                    int maxLevel = entry.getKey().getLevel(Integer.MAX_VALUE);
                    desiredLevel = Math.min(desiredLevel, maxLevel);
                    double wantedExp = entry.getKey().getLevelExp(desiredLevel);
                    newStats.addExperience(entry.getKey().getKey(), wantedExp);
                }
                ((ILivingContainer)tomeStack.m_41720_()).updateLivingStats(tomeStack, newStats);
                inv.m_6836_(slot, tomeStack);
                inv.save();
                this.fromInventory(trainerStack, inv);
            } else {
                System.out.println("Stats are null");
            }
        } else {
            System.out.println("Something went wrong when setting tomeLevel");
        }
    }

    public void fromInventory(ItemStack trainerStack, InventoryTrainingBracelet inv) {
        ArrayList<ItemStack> invList = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            invList.add(inv.m_8020_(i));
        }
        this.fromItemStackList(trainerStack, invList);
    }

    public void fromItemStackList(ItemStack trainerStack, List<ItemStack> tomeList) {
        LivingStats stats = new LivingStats();
        int n = 0;
        block0: for (int i = 0; i < tomeList.size(); ++i) {
            LivingStats tomeStats;
            ItemStack tomeStack = tomeList.get(i);
            if (tomeStack.m_41619_() || !(tomeStack.m_41720_() instanceof ILivingContainer) || (tomeStats = ((ILivingContainer)tomeStack.m_41720_()).getLivingStats(tomeStack)) == null) continue;
            for (Map.Entry<LivingUpgrade, Double> entry : tomeStats.getUpgrades().entrySet()) {
                stats.addExperience(entry.getKey().getKey(), entry.getValue());
                if (++n < 16) continue;
                break block0;
            }
        }
        this.updateLivingStats(trainerStack, stats);
    }

    public InventoryTrainingBracelet toInventory(ItemStack trainerStack) {
        InventoryTrainingBracelet inv = new InventoryTrainingBracelet(trainerStack);
        inv.m_6211_();
        List<ItemStack> stackList = this.toItemStackList(trainerStack);
        for (int i = 0; i < Math.min(stackList.size(), inv.m_6643_()); ++i) {
            inv.m_6836_(i, stackList.get(i));
        }
        return inv;
    }

    public List<ItemStack> toItemStackList(ItemStack trainerStack) {
        ArrayList<ItemStack> tomeList = new ArrayList<ItemStack>();
        LivingStats stats = this.getLivingStats(trainerStack);
        if (stats == null) {
            return tomeList;
        }
        Map<LivingUpgrade, Double> upgradeMap = stats.getUpgrades();
        for (Map.Entry<LivingUpgrade, Double> upgrade : upgradeMap.entrySet()) {
            ItemStack tomeStack = new ItemStack((ItemLike)BloodMagicItems.LIVING_TOME.get());
            LivingStats tomeStats = new LivingStats();
            tomeStats.addExperience(upgrade.getKey().getKey(), upgrade.getValue());
            ((ILivingContainer)tomeStack.m_41720_()).updateLivingStats(tomeStack, tomeStats);
            ILivingContainer.setDisplayIfZero(tomeStack, true);
            tomeList.add(tomeStack);
        }
        return tomeList;
    }
}

